/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.DatasetWizardNewDataset;
import com.jaspersoft.ireport.designer.wizards.FieldsSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.GroupingWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.WizardDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatasetWizardIterator
implements WizardDescriptor.Iterator {
    private int index;
    WizardDescriptor wizard = null;
    private JasperDesign jasperDesign = null;
    List<WizardDescriptor.Panel> panels = null;
    private List<WizardDescriptor.Panel> datasetFromConnectionPanelSet = null;
    private List<WizardDescriptor.Panel> emptyDatasetPanelSet = null;
    private int lastSelectedType = 0;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public void initialize(WizardDescriptor wizard, JasperDesign jd) {
        this.wizard = wizard;
        this.jasperDesign = jd;
        this.wizard.putProperty("jasperdesign", (Object)jd);
    }

    public void appendWizardPanel(WizardDescriptor.Panel panel) {
        ArrayList<WizardDescriptor.Panel> l = new ArrayList<WizardDescriptor.Panel>();
        l.add(panel);
        this.appendWizardPanels(l);
    }

    public void appendWizardPanels(List<WizardDescriptor.Panel> newPanels) {
        this.getPanels().addAll(newPanels);
        for (WizardDescriptor.Panel panel : this.getPanels()) {
            Component c = panel.getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    private List<WizardDescriptor.Panel> getPanels() {
        if (this.panels == null) {
            this.panels = new ArrayList<WizardDescriptor.Panel>();
            this.appendWizardPanel((WizardDescriptor.Panel)new DatasetWizardNewDataset(this.wizard, this));
            this.datasetFromConnectionPanelSet = new ArrayList<WizardDescriptor.Panel>();
            this.datasetFromConnectionPanelSet.add((WizardDescriptor.Panel)new ConnectionSelectionWizardPanel(this.wizard));
            this.datasetFromConnectionPanelSet.add(new FieldsSelectionWizardPanel(this.wizard));
            this.datasetFromConnectionPanelSet.add(new GroupingWizardPanel(this.wizard));
            this.appendWizardPanels(this.datasetFromConnectionPanelSet);
            this.updateStepLabels();
            this.wizard.putProperty("WizardPanel_contentData", ((JComponent)this.datasetFromConnectionPanelSet.get(0).getComponent()).getClientProperty("WizardPanel_contentData"));
        }
        return this.panels;
    }

    public void updatePanels() {
        Integer datasetType = (Integer)this.wizard.getProperty("dataset_type");
        if (datasetType == null) {
            return;
        }
        if (this.lastSelectedType == datasetType) {
            return;
        }
        this.lastSelectedType = datasetType;
        WizardDescriptor.Panel panel = this.getPanels().get(0);
        this.getPanels().clear();
        this.appendWizardPanel(panel);
        if (this.lastSelectedType == 0) {
            this.appendWizardPanels(this.datasetFromConnectionPanelSet);
        } else if (this.lastSelectedType == 1) {
            // empty if block
        }
        this.updateStepLabels();
    }

    private void updateStepLabels() {
        if (this.panels == null) {
            return;
        }
        String[] steps = new String[this.panels.size()];
        int i = 0;
        for (WizardDescriptor.Panel pan : this.panels) {
            steps[i] = pan.getComponent().getName();
            ++i;
        }
        i = 0;
        for (WizardDescriptor.Panel pan : this.panels) {
            if (pan.getComponent() instanceof JComponent) {
                ((JComponent)pan.getComponent()).putClientProperty("WizardPanel_contentData", steps);
                ((JComponent)pan.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            }
            ++i;
        }
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels().get(this.index);
    }

    public String name() {
        return this.index + 1 + " of " + this.getPanels().size();
    }

    public boolean hasNext() {
        return this.index < this.getPanels().size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }
}

