/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.ejbql;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.EJBQLConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.apache.commons.beanutils.PropertyUtils;

public class EJBQLFieldsReader {
    private Interpreter interpreter = null;
    private List reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();
    private String singleClassName = null;

    public EJBQLFieldsReader(String queryStr, List reportParameters) {
        this.setQueryString(queryStr);
        this.setReportParameters(reportParameters);
    }

    public String prepareQuery() throws Exception {
        for (JRDesignParameter param : this.getReportParameters()) {
            Object paramVal;
            String expText;
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                expText = "";
                if (param.getDefaultValueExpression() == null) {
                    expText = param.getDefaultValueExpression().getText();
                }
                if ((paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expText, this.getReportParameters())) == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            expText = "";
            if (param.getDefaultValueExpression() == null) {
                expText = param.getDefaultValueExpression().getText();
            }
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expText, this.getReportParameters());
            String parameterReplacement = "_" + EJBQLFieldsReader.getLiteral(parameterName);
            this.queryParameters.put(parameterReplacement, paramVal);
        }
        return this.queryString;
    }

    protected void setParameter(Query query, String hqlParamName, Object parameterValue) throws Exception {
        if (parameterValue == null) {
            query.setParameter(EJBQLFieldsReader.getLiteral(hqlParamName), parameterValue);
            return;
        }
        query.setParameter(hqlParamName, parameterValue);
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter1 = new Interpreter();
        interpreter1.setClassLoader(interpreter1.getClass().getClassLoader());
        return interpreter1;
    }

    public static String getLiteral(String name) {
        if (EJBQLFieldsReader.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(List reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Vector readFields() throws Exception {
        this.prepareQuery();
        Vector fields = new Vector();
        EntityManager em = null;
        Query query = null;
        this.setSingleClassName(null);
        try {
            IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
            if (!(conn instanceof EJBQLConnection)) {
                throw new Exception("No EJBQL connection selected.");
            }
            em = ((EJBQLConnection)conn).getEntityManager();
            query = em.createQuery(this.queryString);
            for (String parameterName : this.queryParameters.keySet()) {
                query.setParameter(parameterName, this.queryParameters.get(parameterName));
            }
            query.setMaxResults(1);
            List list = query.getResultList();
            if (list.size() > 0) {
                Object obj = list.get(0);
                if (obj != null && obj.getClass().isArray()) {
                    Object[] fiels_obj = (Object[])obj;
                    for (int i = 0; i < fiels_obj.length; ++i) {
                        fields.add(this.createField(fiels_obj[i], i));
                    }
                } else {
                    this.setSingleClassName(obj.getClass().getName());
                    fields = this.getFields(obj);
                }
            }
            Vector vector = fields;
            return vector;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Vector getFields(Object obj) {
        Vector<JRDesignField> fields = new Vector<JRDesignField>();
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors(obj.getClass());
        for (int nd = 0; nd < pd.length; ++nd) {
            String fieldName = pd[nd].getName();
            if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null) continue;
            String returnType = pd[nd].getPropertyType().getName();
            JRDesignField field = new JRDesignField();
            field.setName(fieldName);
            field.setValueClassName(Misc.getJRFieldType(returnType));
            fields.addElement(field);
        }
        return fields;
    }

    public JRDesignField createField(Object obj, int pos) {
        String fieldName = "COLUMN_" + (pos + 1);
        if (pos < 0) {
            fieldName = obj.getClass().getName();
            if (fieldName.indexOf(".") > 0) {
                fieldName = fieldName.substring(fieldName.indexOf(".") + 1);
            }
            if (fieldName.length() == 0) {
                fieldName = "COLUMN_1";
            }
        }
        JRDesignField field = new JRDesignField();
        field.setName(fieldName);
        field.setValueClassName(obj.getClass().getName());
        return field;
    }

    public String getSingleClassName() {
        return this.singleClassName;
    }

    public void setSingleClassName(String singleClassName) {
        this.singleClassName = singleClassName;
    }
}

