/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.DefaultViewer;
import net.sf.jasperreports.web.servlets.NoDecorationViewer;

public class ReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_REPOSITORY_ROOT = "net.sf.jasperreports.web.repository.root";
    public static final String DEFAULT_REPOSITORY_ROOT = "WEB-INF/repository";
    public static final String REQUEST_PARAMETER_REPORT_URI = "jr.uri";
    public static final String REQUEST_PARAMETER_IGNORE_PAGINATION = "jr.ignrpg";
    public static final String REQUEST_PARAMETER_RUN_REPORT = "jr.run";
    public static final String REQUEST_PARAMETER_REPORT_JRXML = "jr.jrxml";
    public static final String REQUEST_PARAMETER_REPORT_VIEWER = "jr.vwr";
    private File repositoryRoot;
    private SimpleFileResolver fileResolver;

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    public void init(ServletConfig config) throws ServletException {
        String realPath;
        super.init(config);
        String repo = this.getInitParameter("repository.root");
        if (repo == null) {
            repo = JRProperties.getProperty(PROPERTY_REPOSITORY_ROOT);
        }
        if (repo == null) {
            repo = DEFAULT_REPOSITORY_ROOT;
        }
        this.repositoryRoot = new File(repo);
        if (!this.repositoryRoot.isAbsolute() && (realPath = config.getServletContext().getRealPath("/")) != null) {
            this.repositoryRoot = new File(new File(realPath), repo);
        }
        this.fileResolver = new SimpleFileResolver(this.repositoryRoot);
        this.fileResolver.setResolveAbsolutePath(true);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        WebReportContext webReportContext = WebReportContext.getInstance(request);
        try {
            this.runReport(request, webReportContext);
            String viewer = request.getParameter(REQUEST_PARAMETER_REPORT_VIEWER);
            if (viewer == null || viewer.trim().length() == 0) {
                new DefaultViewer().render(request, webReportContext, out);
            } else {
                new NoDecorationViewer().render(request, webReportContext, out);
            }
        }
        catch (JRException e) {
            out.println("<html>");
            out.println("<head>");
            out.println("<title>JasperReports - Web Application Sample</title>");
            out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../stylesheet.css\" title=\"Style\">");
            out.println("</head>");
            out.println("<body bgcolor=\"white\">");
            out.println("<span class=\"bnew\">JasperReports encountered this error :</span>");
            out.println("<pre>");
            e.printStackTrace(out);
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    public void runReport(HttpServletRequest request, WebReportContext webReportContext) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print");
        String run = request.getParameter(REQUEST_PARAMETER_RUN_REPORT);
        if (jasperPrint == null || Boolean.valueOf(run).booleanValue()) {
            String reportUri = request.getParameter(REQUEST_PARAMETER_REPORT_URI);
            webReportContext.setParameterValue("REPORT_FILE_RESOLVER", this.getFileResolver());
            JRResourcesUtil.setThreadFileResolver(this.fileResolver);
            Boolean isIgnorePagination = Boolean.valueOf(request.getParameter(REQUEST_PARAMETER_IGNORE_PAGINATION));
            if (isIgnorePagination != null) {
                webReportContext.setParameterValue("IS_IGNORE_PAGINATION", isIgnorePagination);
            }
            JasperReport jasperReport = null;
            String jrxml = request.getParameter(REQUEST_PARAMETER_REPORT_JRXML);
            if (jrxml != null && jrxml.trim().length() > 0) {
                jrxml = jrxml.trim();
                jasperReport = JasperCompileManager.compileReport(new ByteArrayInputStream(jrxml.getBytes()));
            } else if (reportUri != null && reportUri.trim().length() > 0) {
                reportUri = reportUri.trim();
                jasperReport = RepositoryUtil.getReport(reportUri);
            }
            if (jasperReport == null) {
                throw new JRException("Report not found at : " + reportUri);
            }
            jasperPrint = JasperFillManager.fillReport(jasperReport, webReportContext.getParameterValues());
            webReportContext.setParameterValue("net.sf.jasperreports.web.jasper_print", jasperPrint);
        }
    }

    public static String extractReportUri(String paramReportUri) {
        String lcReportUri = paramReportUri.toLowerCase();
        if (lcReportUri.endsWith(".jasper")) {
            paramReportUri = paramReportUri.substring(0, lcReportUri.lastIndexOf(".jasper"));
        } else if (lcReportUri.endsWith(".jrxml")) {
            paramReportUri = paramReportUri.substring(0, lcReportUri.lastIndexOf(".jrxml"));
        }
        return paramReportUri;
    }
}

