/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import jxl.CellView;
import jxl.JXLException;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJExcelApiHandler;
import net.sf.jasperreports.engine.export.JExcelApiExporterContext;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiExporter
extends JRXlsAbstractExporter {
    private static final Log log = LogFactory.getLog(JExcelApiExporter.class);
    public static final String PROPERTY_USE_TEMP_FILE = "net.sf.jasperreports.export.jxl.use.temp.file";
    public static final String PROPERTY_COMPLEX_FORMAT = "net.sf.jasperreports.export.jxl.cell.complex.format";
    public static final String JXL_EXPORTER_KEY = "net.sf.jasperreports.jxl";
    protected static final Colour WHITE = Colour.WHITE;
    protected static final Colour BLACK = Colour.BLACK;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map<Color, Colour> colorsCache = new ReferenceMap();
    private static final Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map<StyleInfo, WritableCellFormat> loadedCellStyles = new HashMap<StyleInfo, WritableCellFormat>();
    private WritableWorkbook workbook;
    private WritableSheet sheet;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map<String, NumberFormat> numberFormats;
    private Map<String, DateFormat> dateFormats;
    protected Map<Color, Colour> workbookColours = new HashMap<Color, Colour>();
    protected Map<Colour, RGB> usedColours = new HashMap<Colour, RGB>();
    protected String password;
    protected ExporterNature nature;
    protected boolean useTempFile;
    protected boolean complexFormat;
    protected JExcelApiExporterContext exporterContext = new ExporterContext();

    public JExcelApiExporter() {
        this.numberFormats = new HashMap<String, NumberFormat>();
        this.dateFormats = new HashMap<String, DateFormat>();
    }

    protected void setParameters() {
        super.setParameters();
        if (this.createCustomPalette) {
            this.initCustomPalette();
        }
        this.password = this.getStringParameter(JExcelApiExporterParameter.PASSWORD, "net.sf.jasperreports.export.xls.password");
        this.nature = new JExcelApiExporterNature(this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
        this.useTempFile = JRProperties.getBooleanProperty(this.jasperPrint, PROPERTY_USE_TEMP_FILE, false);
        this.complexFormat = JRProperties.getBooleanProperty(this.jasperPrint, PROPERTY_COMPLEX_FORMAT, false);
    }

    protected void initCustomPalette() {
        for (int i = 0; i < FIXED_COLOURS.length; ++i) {
            Colour colour = FIXED_COLOURS[i];
            this.setColourUsed(colour);
        }
    }

    protected void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    protected void setColourUsed(Colour colour, Color reportColour) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying palette colour " + colour.getValue() + " to " + reportColour));
        }
        int red = reportColour.getRed();
        int green = reportColour.getGreen();
        int blue = reportColour.getBlue();
        this.workbook.setColourRGB(colour, red, green, blue);
        RGB customRGB = new RGB(red, green, blue);
        this.usedColours.put(colour, customRGB);
    }

    protected void setBackground() {
        this.backgroundMode = this.isWhitePageBackground ? Pattern.SOLID : Pattern.NONE;
    }

    protected void openWorkbook(OutputStream os) throws JRException {
        try {
            WorkbookSettings settings = new WorkbookSettings();
            settings.setUseTemporaryFileDuringWrite(this.useTempFile);
            this.workbook = Workbook.createWorkbook((OutputStream)os, (WorkbookSettings)settings);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name, Integer.MAX_VALUE);
        this.setSheetSettings(this.sheet);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(int col, int width, boolean autoFit) {
        CellView cv = new CellView();
        if (!autoFit) {
            cv.setSize(43 * width);
        }
        this.sheet.setColumnView(col, cv);
    }

    protected void updateColumn(int col, boolean autoFit) {
        CellView cv = new CellView();
        if (autoFit) {
            cv.setAutosize(true);
        }
        this.sheet.setColumnView(col, cv);
    }

    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        if (yCut.isAutoFit()) {
            try {
                CellView cv = this.sheet.getRowView(rowIndex) == null ? new CellView() : this.sheet.getRowView(rowIndex);
                cv.setSize(LengthUtil.twip(lastRowHeight));
                cv.setAutosize(true);
                this.sheet.setRowView(rowIndex, cv);
            }
            catch (RowsExceededException e) {
                throw new JRException("Too many rows in sheet " + this.sheet.getName() + ": " + rowIndex, e);
            }
        }
        try {
            this.sheet.setRowView(rowIndex, LengthUtil.twip(lastRowHeight));
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setCell(JRExporterGridCell gridCell, int x, int y) {
    }

    protected void removeColumn(int col) {
        this.sheet.removeColumn(col);
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        Colour forecolor = BLACK;
        if (gridCell.getForecolor() != null) {
            forecolor = this.getWorkbookColour(gridCell.getForecolor());
        }
        Pattern mode = this.backgroundMode;
        Colour backcolor = WHITE;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell);
        try {
            this.sheet.addCell((WritableCell)new Blank(colIndex, rowIndex, (CellFormat)cellStyle));
        }
        catch (RowsExceededException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
        catch (WriteException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor2 = this.getWorkbookColour(line.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue(), this.getLocale());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, boxStyle, this.isCellLocked(line));
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        Colour forecolor = this.getWorkbookColour(element.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, gridCell, this.isCellLocked(element));
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        JRStyledText styledText = this.getStyledText(text);
        if (styledText != null) {
            Colour forecolor = this.getWorkbookColour(text.getForecolor());
            WritableFont cellFont = this.getLoadedFont(text, forecolor.getValue(), this.getTextLocale(text));
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiExporter.getTextAlignHolder(text);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, gridCell, this.isWrapText(text), this.isCellLocked(text));
            String textStr = styledText.getText();
            String href = null;
            JRHyperlinkProducer customHandler = this.getCustomHandler(text);
            if (customHandler == null) {
                switch (text.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        href = text.getHyperlinkReference();
                        break;
                    }
                }
            } else {
                href = customHandler.getHyperlink(text);
            }
            try {
                block12: {
                    if (href != null) {
                        try {
                            URL url = new URL(href);
                            WritableHyperlink hyperlink = new WritableHyperlink(col, row, col, row, url);
                            this.sheet.addHyperlink(hyperlink);
                        }
                        catch (MalformedURLException e) {
                            if (!log.isWarnEnabled()) break block12;
                            log.warn((Object)("Reference \"" + href + "\" could not be parsed as URL."), (Throwable)e);
                        }
                    }
                }
                this.addCell(col, row, text, textStr, baseStyle);
            }
            catch (Exception e) {
                throw new JRException("Can't add cell.", e);
            }
        }
    }

    protected void addCell(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws WriteException, RowsExceededException, JRException {
        CellValue cellValue = null;
        TextValue textValue = null;
        String textFormula = this.getFormula(text);
        if (textFormula != null) {
            textValue = this.getTextValue(text, textStr);
            cellValue = this.getFormulaCellValue(x, y, text, textValue, textFormula, baseStyle, this.isComplexFormat(text));
        }
        if (cellValue == null) {
            if (this.isDetectCellType) {
                if (textFormula == null) {
                    textValue = this.getTextValue(text, textStr);
                }
                cellValue = this.getDetectedCellValue(x, y, text, textValue, baseStyle, this.isComplexFormat(text));
            } else {
                cellValue = this.getLabelCell(x, y, textStr, baseStyle);
            }
        }
        this.sheet.addCell(cellValue);
    }

    protected CellValue getFormulaCellValue(int x, int y, JRPrintText textElement, TextValue textValue, String formula, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        FormulaTextValueHandler handler = new FormulaTextValueHandler(x, y, textElement, formula, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected CellValue getDetectedCellValue(int x, int y, JRPrintText textElement, TextValue textValue, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        CellTextValueHandler handler = new CellTextValueHandler(x, y, textElement, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected NumberFormat getNumberFormat(String convertedPattern, boolean isComplexFormat) {
        NumberFormat cellFormat = this.numberFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = isComplexFormat ? new NumberFormat(convertedPattern, NumberFormat.COMPLEX_FORMAT) : new NumberFormat(convertedPattern);
            this.numberFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected DateFormat getDateFormat(String convertedPattern) {
        DateFormat cellFormat = this.dateFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new DateFormat(convertedPattern);
            this.dateFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected CellValue getLabelCell(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
        return new Label(x, y, textStr, (CellFormat)cellStyle);
    }

    protected void addMergeRegion(JRExporterGridCell gridCell, int x, int y) throws JRException {
        if (gridCell.getColSpan() > 1 || gridCell.getRowSpan() > 1 && !this.isCollapseRowSpan) {
            try {
                if (this.isCollapseRowSpan) {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y);
                } else {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y + gridCell.getRowSpan() - 1);
                }
            }
            catch (JXLException e) {
                throw new JRException("Can't merge cells.", e);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return Alignment.RIGHT.getValue();
            }
            case CENTER: {
                return Alignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case MIDDLE: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return Orientation.PLUS_90.getValue();
            }
            case RIGHT: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    public void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int col, int row, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
        int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
        int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
        int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = element.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getType() == 0) {
                if ((renderer = JRImageRenderer.getOnErrorRendererForImageData(renderer, element.getOnErrorTypeValue())) != null) {
                    renderer = JRImageRenderer.getOnErrorRendererForDimension(renderer, element.getOnErrorTypeValue());
                }
            } else {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(element.getWidth(), element.getHeight()), ModeEnum.OPAQUE == element.getModeValue() ? element.getBackcolor() : null);
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (element.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    xalignFactor = 1.0f;
                    break;
                }
                case CENTER: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (element.getVerticalAlignmentValue()) {
                case BOTTOM: {
                    yalignFactor = 1.0f;
                    break;
                }
                case MIDDLE: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            byte[] imageData = null;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            switch (element.getScaleImageValue()) {
                case CLIP: {
                    int dpi = JRProperties.getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
                    double scale = (double)dpi / 72.0;
                    BufferedImage bi = new BufferedImage((int)(scale * (double)availableImageWidth), (int)(scale * (double)availableImageHeight), 2);
                    Graphics2D grx = bi.createGraphics();
                    grx.scale(scale, scale);
                    grx.clip(new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                    renderer.render(grx, new Rectangle((int)(xalignFactor * (float)(availableImageWidth - normalWidth)), (int)(yalignFactor * (float)(availableImageHeight - normalHeight)), normalWidth, normalHeight));
                    topOffset = topPadding;
                    leftOffset = leftPadding;
                    bottomOffset = bottomPadding;
                    rightOffset = rightPadding;
                    imageData = JRImageLoader.loadImageDataFromAWTImage(bi, (byte)3);
                    break;
                }
                case FILL_FRAME: {
                    topOffset = topPadding;
                    leftOffset = leftPadding;
                    bottomOffset = bottomPadding;
                    rightOffset = rightPadding;
                    imageData = renderer.getImageData();
                    break;
                }
                default: {
                    if (element.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    topOffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    leftOffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    bottomOffset = bottomPadding + (int)((1.0f - yalignFactor) * (float)(availableImageHeight - normalHeight));
                    rightOffset = rightPadding + (int)((1.0f - xalignFactor) * (float)(availableImageWidth - normalWidth));
                    imageData = renderer.getImageData();
                }
            }
            Pattern mode = this.backgroundMode;
            Colour background = WHITE;
            if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                background = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                background = this.getWorkbookColour(element.getBackcolor(), true);
            }
            Colour forecolor = this.getWorkbookColour(element.getLineBox().getPen().getLineColor());
            WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, cellFont2, gridCell, this.isCellLocked(element));
            try {
                this.sheet.addCell((WritableCell)new Blank(col, row, (CellFormat)cellStyle2));
                double leftPos = this.getColumnRelativePosition(layout, col, leftOffset);
                double topPos = this.getRowRelativePosition(layout, yCutsRow, topOffset);
                WritableImage image = new WritableImage((double)(col - emptyCols) + leftPos, (double)row + topPos, this.getColumnRelativePosition(layout, col, element.getWidth() - rightOffset) - leftPos, this.getRowRelativePosition(layout, yCutsRow, element.getHeight() - bottomOffset) - topPos, imageData);
                this.sheet.addImage(image);
            }
            catch (Exception ex) {
                throw new JRException("The cell cannot be added", ex);
            }
            catch (Error err) {
                throw new JRException("The cell cannot be added", err);
            }
        }
    }

    protected double getColumnRelativePosition(JRGridLayout layout, int col, int offset) {
        int colWidth;
        double colRelPos = 0.0;
        int colIndex = 0;
        for (int cumulativeColWidth = 0; cumulativeColWidth < offset; cumulativeColWidth += colWidth) {
            colWidth = layout.getColumnWidth(col + colIndex);
            if (cumulativeColWidth + colWidth < offset) {
                ++colIndex;
                continue;
            }
            colRelPos += (double)colIndex + (double)(offset - cumulativeColWidth) / (double)colWidth;
        }
        return colRelPos;
    }

    protected double getRowRelativePosition(JRGridLayout layout, int row, int offset) {
        int rowHeight;
        double rowRelPos = 0.0;
        int rowIndex = 0;
        for (int cumulativeRowHeight = 0; cumulativeRowHeight < offset; cumulativeRowHeight += rowHeight) {
            int n = rowHeight = this.isCollapseRowSpan ? layout.getMaxRowHeight(row + rowIndex) : layout.getRowHeight(row + rowIndex);
            if (cumulativeRowHeight + rowHeight < offset) {
                ++rowIndex;
                continue;
            }
            rowRelPos += (double)rowIndex + (double)(offset - cumulativeRowHeight) / (double)rowHeight;
        }
        return rowRelPos;
    }

    protected Colour getWorkbookColour(Color awtColor, boolean isBackcolor) {
        if (isBackcolor && awtColor.getRGB() == Color.black.getRGB()) {
            return Colour.PALETTE_BLACK;
        }
        return this.getWorkbookColour(awtColor);
    }

    protected Colour getWorkbookColour(Color awtColor) {
        Colour colour;
        if (this.createCustomPalette) {
            colour = this.workbookColours.get(awtColor);
            if (colour == null) {
                colour = this.determineWorkbookColour(awtColor);
                this.workbookColours.put(awtColor, colour);
            }
        } else {
            colour = JExcelApiExporter.getNearestColour(awtColor);
        }
        return colour;
    }

    protected Colour determineWorkbookColour(Color awtColor) {
        Colour workbookColour;
        int minDist = 999;
        Colour minColour = null;
        int minDistAvailable = 999;
        Colour minColourAvailable = null;
        Colour[] colors = Colour.getAllColours();
        for (int i = 0; i < colors.length; ++i) {
            Colour colour = colors[i];
            RGB customRGB = this.usedColours.get(colour);
            RGB rgb = customRGB == null ? colour.getDefaultRGB() : customRGB;
            int dist = JExcelApiExporter.rgbDistance(awtColor, rgb);
            if (dist < minDist) {
                minDist = dist;
                minColour = colour;
            }
            if (dist == 0) break;
            if (customRGB != null || dist >= minDistAvailable) continue;
            minDistAvailable = dist;
            minColourAvailable = colour;
        }
        if (minDist == 0) {
            if (!this.usedColours.containsKey(minColour)) {
                this.setColourUsed(minColour);
            }
            workbookColour = minColour;
        } else if (minColourAvailable == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No more available colours in the palette.  Using the nearest match for " + awtColor));
            }
            workbookColour = minColour;
        } else {
            this.setColourUsed(minColourAvailable, awtColor);
            workbookColour = minColourAvailable;
        }
        return workbookColour;
    }

    protected static Colour getNearestColour(Color awtColor) {
        Colour color = colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    Colour crtColor = colors[i];
                    int diff = JExcelApiExporter.rgbDistance(awtColor, crtColor.getDefaultRGB());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    protected static int rgbDistance(Color awtColor, RGB rgb) {
        return Math.abs(rgb.getRed() - awtColor.getRed()) + Math.abs(rgb.getGreen() - awtColor.getGreen()) + Math.abs(rgb.getBlue() - awtColor.getBlue());
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor, Locale locale) throws JRException {
        WritableFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                WritableFont cf = (WritableFont)this.loadedFonts.get(i);
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                } else {
                    FontFamily family;
                    String exportFont;
                    FontInfo fontInfo = JRFontUtil.getFontInfo(fontName, locale);
                    if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                        fontName = exportFont;
                    }
                }
                if (!cf.getName().equals(fontName) || cf.getColour().getValue() != forecolor || cf.getPointSize() != fontSize || !(cf.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf.isStruckout() != font.isStrikeThrough() || !(cf.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf.isItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        try {
            if (cellFont == null) {
                int fontSize = font.getFontSize();
                if (this.isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
                    fontName = (String)this.fontMap.get(fontName);
                }
                cellFont = new WritableFont(WritableFont.createFont((String)fontName), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                cellFont.setStruckout(font.isStrikeThrough());
                this.loadedFonts.add(cellFont);
            }
        }
        catch (Exception e) {
            throw new JRException("Can't get loaded fonts.", e);
        }
        return cellFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, JRExporterGridCell gridCell) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, gridCell);
        return this.getLoadedCellStyle(styleKey);
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, JRExporterGridCell gridCell, boolean cellLocked) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, gridCell, true, cellLocked);
        return this.getLoadedCellStyle(styleKey);
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, BoxStyle box, boolean cellLocked) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, box, true, cellLocked);
        return this.getLoadedCellStyle(styleKey);
    }

    protected WritableCellFormat getLoadedCellStyle(StyleInfo styleKey) throws JRException {
        WritableCellFormat cellStyle = this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            try {
                cellStyle = styleKey.getDisplayFormat() == null ? new WritableCellFormat(styleKey.font) : new WritableCellFormat(styleKey.font, styleKey.getDisplayFormat());
                cellStyle.setBackground(styleKey.backcolor, styleKey.mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)styleKey.horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleKey.verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)styleKey.rotation));
                cellStyle.setWrap(styleKey.isWrapText);
                cellStyle.setLocked(styleKey.isCellLocked);
                if (!this.isIgnoreCellBorder) {
                    BoxStyle box = styleKey.box;
                    cellStyle.setBorder(Border.TOP, box.borderStyle[0], box.borderColour[0]);
                    cellStyle.setBorder(Border.BOTTOM, box.borderStyle[2], box.borderColour[2]);
                    cellStyle.setBorder(Border.LEFT, box.borderStyle[1], box.borderColour[1]);
                    cellStyle.setBorder(Border.RIGHT, box.borderStyle[3], box.borderColour[3]);
                }
            }
            catch (Exception e) {
                throw new JRException("Error setting cellFormat-template.", e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    protected static BorderLineStyle getBorderLineStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return BorderLineStyle.DOUBLE;
                }
                case DOTTED: {
                    return BorderLineStyle.DOTTED;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderLineStyle.MEDIUM_DASHED;
                    }
                    return BorderLineStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderLineStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderLineStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderLineStyle.THIN;
            }
            return BorderLineStyle.HAIR;
        }
        return BorderLineStyle.NONE;
    }

    private final void setSheetSettings(WritableSheet sheet) {
        String fitHeight;
        PageOrientation po = this.jasperPrint.getOrientationValue() == OrientationEnum.PORTRAIT ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize(this.jasperPrint);
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        if (this.jasperPrint.getTopMargin() != null) {
            sheets.setTopMargin(LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getTopMargin().intValue()));
        }
        if (this.jasperPrint.getLeftMargin() != null) {
            sheets.setLeftMargin(LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getLeftMargin().intValue()));
        }
        if (this.jasperPrint.getRightMargin() != null) {
            sheets.setRightMargin(LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getRightMargin().intValue()));
        }
        if (this.jasperPrint.getBottomMargin() != null) {
            sheets.setBottomMargin(LengthUtil.inchNoRound(this.isIgnorePageMargins ? 0.0 : (double)this.jasperPrint.getBottomMargin().intValue()));
        }
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
        String fitWidth = JRProperties.getProperty(this.jasperPrint, "net.sf.jasperreports.export.xls.fit.width");
        if (fitWidth != null && fitWidth.length() > 0) {
            sheets.setFitWidth(Integer.valueOf(fitWidth).intValue());
            sheets.setFitToPages(true);
        }
        if ((fitHeight = JRProperties.getProperty(this.jasperPrint, "net.sf.jasperreports.export.xls.fit.height")) != null && fitHeight.length() > 0) {
            sheets.setFitHeight(Integer.valueOf(fitHeight).intValue());
            sheets.setFitToPages(true);
        }
        if (this.password != null) {
            sheets.setPassword(this.password);
            sheets.setProtected(true);
        }
        if (this.sheetHeaderLeft != null) {
            sheets.getHeader().getLeft().append(this.sheetHeaderLeft);
        }
        if (this.sheetHeaderCenter != null) {
            sheets.getHeader().getCentre().append(this.sheetHeaderCenter);
        }
        if (this.sheetHeaderRight != null) {
            sheets.getHeader().getRight().append(this.sheetHeaderRight);
        }
        if (this.sheetFooterLeft != null) {
            sheets.getFooter().getLeft().append(this.sheetFooterLeft);
        }
        if (this.sheetFooterCenter != null) {
            sheets.getFooter().getCentre().append(this.sheetFooterCenter);
        }
        if (this.sheetFooterRight != null) {
            sheets.getFooter().getRight().append(this.sheetFooterRight);
        }
        this.maxRowFreezeIndex = 0;
        this.maxColumnFreezeIndex = 0;
    }

    private final PaperSize getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalAlignEnum horizontalAlignment;
        VerticalAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignmentValue();
                verticalAlignment = textElement.getVerticalAlignmentValue();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor = this.getWorkbookColour(frame.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(frame.getBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell, this.isCellLocked(frame));
        Blank cell = new Blank(col, row, (CellFormat)cellStyle);
        try {
            this.sheet.addCell((WritableCell)cell);
        }
        catch (JXLException e) {
            throw new JRException("Can't add cell.", e);
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementJExcelApiHandler handler = (GenericElementJExcelApiHandler)GenericElementHandlerEnviroment.getHandler(element.getGenericType(), JXL_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLS generic element handler for " + element.getGenericType()));
        }
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    protected String getExporterKey() {
        return JXL_EXPORTER_KEY;
    }

    protected boolean isComplexFormat(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_COMPLEX_FORMAT)) {
            return JRProperties.getBooleanProperty(element, PROPERTY_COMPLEX_FORMAT, this.complexFormat);
        }
        return this.complexFormat;
    }

    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
        int maxRowIndex;
        int n = this.isFreezeRowEdge ? Math.max(rowIndex, this.maxRowFreezeIndex) : (maxRowIndex = isRowEdge ? rowIndex : Math.max(rowIndex, this.maxRowFreezeIndex));
        int maxColIndex = this.isFreezeColumnEdge ? Math.max(colIndex, this.maxColumnFreezeIndex) : (isColumnEdge ? colIndex : Math.max(colIndex, this.maxColumnFreezeIndex));
        SheetSettings settings = this.sheet.getSettings();
        settings.setVerticalFreeze(maxRowIndex);
        settings.setHorizontalFreeze(maxColIndex);
        this.maxRowFreezeIndex = maxRowIndex;
        this.maxColumnFreezeIndex = maxColIndex;
        this.isFreezeRowEdge = isRowEdge;
        this.isFreezeColumnEdge = isColumnEdge;
    }

    protected void setSheetName(String sheetName) {
        this.sheet.setName(sheetName);
    }

    protected void setAutoFilter(String autoFilterRange) {
    }

    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
        SortedMap<String, Integer> levelMap = levelInfo.getLevelMap();
        try {
            if (levelMap != null && levelMap.size() > 0) {
                for (String l : levelMap.keySet()) {
                    if (level != null && l.compareTo(level) < 0) continue;
                    Integer startIndex = (Integer)levelMap.get(l);
                    if (levelInfo.getEndIndex() <= startIndex) continue;
                    this.sheet.setRowGroup(startIndex.intValue(), levelInfo.getEndIndex().intValue(), false);
                }
            }
        }
        catch (RowsExceededException e) {
            throw new JRRuntimeException(e);
        }
        catch (WriteException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected class StyleInfo {
        protected final Pattern mode;
        protected final Colour backcolor;
        protected final int horizontalAlignment;
        protected final int verticalAlignment;
        protected final int rotation;
        protected final WritableFont font;
        protected final BoxStyle box;
        protected final boolean isWrapText;
        protected final boolean isCellLocked;
        private DisplayFormat displayFormat;
        private int hashCode;

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jExcelApiExporter.new BoxStyle(gridCell), true);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell, boolean wrapText) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jExcelApiExporter.new BoxStyle(gridCell), wrapText);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jExcelApiExporter.new BoxStyle(gridCell), wrapText, cellLocked);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box, boolean wrapText) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, wrapText, true);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box, boolean wrapText, boolean cellLocked) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.isWrapText = wrapText;
            this.isCellLocked = cellLocked;
            this.computeHash();
        }

        protected void computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor.hashCode();
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + this.font.hashCode();
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
            hash = 31 * hash + (this.isWrapText ? 0 : 1);
            this.hashCode = hash = 31 * hash + (this.isCellLocked ? 0 : 1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo k = (StyleInfo)o;
            return k.mode.equals(this.mode) && k.backcolor.equals(this.backcolor) && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && k.font.equals((Object)this.font) && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box)) && (k.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && k.displayFormat.equals(this.displayFormat) && k.isWrapText == JExcelApiExporter.this.wrapText && k.isCellLocked == JExcelApiExporter.this.cellLocked);
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + "," + JExcelApiExporter.this.wrapText + "," + JExcelApiExporter.this.cellLocked + ")";
        }
    }

    protected class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderLineStyle[] borderStyle = new BorderLineStyle[]{BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE};
        protected Colour[] borderColour = new Colour[]{BLACK, BLACK, BLACK, BLACK};
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JExcelApiExporter.getBorderLineStyle(pen);
            this.borderColour[side] = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            JRPrintElement element;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
            }
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JExcelApiExporter.getBorderLineStyle(box.getTopPen());
            this.borderColour[0] = JExcelApiExporter.this.getWorkbookColour(box.getTopPen().getLineColor());
            this.borderStyle[2] = JExcelApiExporter.getBorderLineStyle(box.getBottomPen());
            this.borderColour[2] = JExcelApiExporter.this.getWorkbookColour(box.getBottomPen().getLineColor());
            this.borderStyle[1] = JExcelApiExporter.getBorderLineStyle(box.getLeftPen());
            this.borderColour[1] = JExcelApiExporter.this.getWorkbookColour(box.getLeftPen().getLineColor());
            this.borderStyle[3] = JExcelApiExporter.getBorderLineStyle(box.getRightPen());
            this.borderColour[3] = JExcelApiExporter.this.getWorkbookColour(box.getRightPen().getLineColor());
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderLineStyle.NONE && this.borderStyle[1] == BorderLineStyle.NONE && this.borderStyle[2] == BorderLineStyle.NONE && this.borderStyle[3] == BorderLineStyle.NONE) {
                BorderLineStyle style = JExcelApiExporter.getBorderLineStyle(pen);
                Colour colour = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
                this.borderStyle[0] = style;
                this.borderStyle[1] = style;
                this.borderStyle[2] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[1] = colour;
                this.borderColour[2] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[2].hashCode();
            hashCode = 31 * hashCode + this.borderColour[2].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[1].hashCode();
            hashCode = 31 * hashCode + this.borderColour[1].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[3].hashCode();
            hashCode = 31 * hashCode + this.borderColour[3].hashCode();
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0].equals(this.borderStyle[0]) && b.borderColour[0].equals(this.borderColour[0]) && b.borderStyle[1].equals(this.borderStyle[1]) && b.borderColour[1].equals(this.borderColour[1]) && b.borderStyle[2].equals(this.borderStyle[2]) && b.borderColour[2].equals(this.borderColour[2]) && b.borderStyle[3].equals(this.borderStyle[3]) && b.borderColour[3].equals(this.borderColour[3]);
        }

        public String toString() {
            return "(" + this.borderStyle[0].getValue() + "/" + this.borderColour[0].getValue() + "," + this.borderStyle[2].getValue() + "/" + this.borderColour[2].getValue() + "," + this.borderStyle[1].getValue() + "/" + this.borderColour[1].getValue() + "," + this.borderStyle[3].getValue() + "/" + this.borderColour[3].getValue() + ")";
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public CellTextValueHandler(int x, int y, JRPrintText textElement, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        public void handle(StringTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, textValue.getText(), (CellFormat)cellStyle);
        }

        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Number(this.x, this.y, textValue.getValue().doubleValue(), (CellFormat)cellStyle);
        }

        public void handle(DateTextValue textValue) throws JRException {
            this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern())));
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            Date date = textValue.getValue();
            if (date == null) {
                this.result = this.blank(cellStyle);
            } else {
                date = JExcelApiExporter.this.translateDateValue(this.textElement, date);
                this.result = new DateTime(this.x, this.y, date, (CellFormat)cellStyle);
            }
        }

        public void handle(BooleanTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Boolean(this.x, this.y, textValue.getValue().booleanValue(), (CellFormat)cellStyle);
        }

        protected Blank blank(WritableCellFormat cellStyle) {
            return new Blank(this.x, this.y, (CellFormat)cellStyle);
        }

        public CellValue getResult() {
            return this.result;
        }

        public boolean isCellComplexFormat() {
            return this.cellComplexFormat;
        }
    }

    protected class FormulaTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final String formula;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public FormulaTextValueHandler(int x, int y, JRPrintText textElement, String formula, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.formula = formula;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        public void handle(StringTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            this.result = this.formula();
        }

        public void handle(DateTextValue textValue) throws JRException {
            this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern())));
            this.result = this.formula();
        }

        public void handle(BooleanTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        protected Formula formula() throws JRException {
            try {
                return new Formula(this.x, this.y, this.formula, (CellFormat)JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle));
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }

        public CellValue getResult() {
            return this.result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JExcelApiExporterContext {
        protected ExporterContext() {
        }

        public String getExportPropertiesPrefix() {
            return "net.sf.jasperreports.export.xls.";
        }
    }
}

