/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluatorDecorator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillTableSubreport
extends JRFillSubreport {
    private final JasperReport tableReport;
    private final Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators;

    protected FillTableSubreport(JRBaseFiller filler, JRSubreport subreport, JRFillObjectFactory factory, JasperReport tableReport, Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators) {
        super(filler, subreport, factory);
        this.tableReport = tableReport;
        this.builtinEvaluators = builtinEvaluators;
    }

    @Override
    protected JasperReport evaluateReport(byte evaluation) throws JRException {
        return this.tableReport;
    }

    @Override
    protected DatasetExpressionEvaluator createEvaluator() throws JRException {
        DatasetExpressionEvaluator evaluator = super.createEvaluator();
        if (!this.builtinEvaluators.isEmpty()) {
            evaluator = new BuiltinExpressionEvaluatorDecorator(evaluator, this.builtinEvaluators);
        }
        return evaluator;
    }

    @Override
    protected void evaluateSubreport(byte evaluation) throws JRException {
        super.evaluateSubreport(evaluation);
    }

    @Override
    protected Map<String, Object> evaluateParameterValues(byte evaluation) throws JRException {
        Map<String, Object> values = super.evaluateParameterValues(evaluation);
        this.copyConnectionParameter(values);
        this.copyResourceBundleParameter(values);
        this.copyTemplatesParameter(values);
        return values;
    }

    protected void copyConnectionParameter(Map<String, Object> parameterValues) {
        Connection connection;
        String language;
        JRQuery query;
        if (!parameterValues.containsKey("REPORT_CONNECTION") && this.getConnectionExpression() == null && (query = this.tableReport.getQuery()) != null && ((language = query.getLanguage()).equals("sql") || language.equals("SQL")) && (connection = (Connection)this.filler.getParameterValuesMap().get("REPORT_CONNECTION")) != null) {
            parameterValues.put("REPORT_CONNECTION", connection);
        }
    }

    protected void copyResourceBundleParameter(Map<String, Object> parameterValues) {
        ResourceBundle resourceBundle;
        if (!parameterValues.containsKey("REPORT_RESOURCE_BUNDLE") && this.tableReport.getResourceBundle() == null && (resourceBundle = (ResourceBundle)this.filler.getParameterValuesMap().get("REPORT_RESOURCE_BUNDLE")) != null) {
            parameterValues.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        }
    }

    protected void copyTemplatesParameter(Map<String, Object> parameterValues) {
        List<JRTemplate> templates = this.filler.getTemplates();
        parameterValues.put("REPORT_TEMPLATES", templates);
    }

    protected FillPrepareResult prepareSubreport(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = this.prepare(availableHeight, isOverflow);
        return FillPrepareResult.printStretch(this.getStretchHeight(), willOverflow);
    }

    @Override
    protected Collection<JRPrintElement> getPrintElements() {
        return super.getPrintElements();
    }

    @Override
    protected int getContentsStretchHeight() {
        return super.getContentsStretchHeight();
    }

    protected List<JRStyle> getSubreportStyles() {
        return this.subreportFiller.getJasperPrint().getStylesList();
    }

    protected List<JROrigin> getSubreportOrigins() {
        return this.subreportFiller.getJasperPrint().getOriginsList();
    }

    @Override
    protected void cancelSubreportFill() throws JRException {
        super.cancelSubreportFill();
    }
}

