/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.Serializable;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMapComponent
implements MapComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LATITUDE_EXPRESSION = "latitudeExpression";
    public static final String PROPERTY_LONGITUDE_EXPRESSION = "longitudeExpression";
    public static final String PROPERTY_ZOOM_EXPRESSION = "zoomExpression";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    private JRExpression latitudeExpression;
    private JRExpression longitudeExpression;
    private JRExpression zoomExpression;
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardMapComponent() {
    }

    public StandardMapComponent(MapComponent map, JRBaseObjectFactory objectFactory) {
        this.latitudeExpression = objectFactory.getExpression(map.getLatitudeExpression());
        this.longitudeExpression = objectFactory.getExpression(map.getLongitudeExpression());
        this.zoomExpression = objectFactory.getExpression(map.getZoomExpression());
        this.evaluationTime = map.getEvaluationTime();
        this.evaluationGroup = map.getEvaluationGroup();
    }

    public JRExpression getLatitudeExpression() {
        return this.latitudeExpression;
    }

    public void setLatitudeExpression(JRExpression latitudeExpression) {
        JRExpression old = this.latitudeExpression;
        this.latitudeExpression = latitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LATITUDE_EXPRESSION, old, this.latitudeExpression);
    }

    public JRExpression getLongitudeExpression() {
        return this.longitudeExpression;
    }

    public void setLongitudeExpression(JRExpression longitudeExpression) {
        JRExpression old = this.longitudeExpression;
        this.longitudeExpression = longitudeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_LONGITUDE_EXPRESSION, old, this.longitudeExpression);
    }

    public JRExpression getZoomExpression() {
        return this.zoomExpression;
    }

    public void setZoomExpression(JRExpression zoomExpression) {
        JRExpression old = this.zoomExpression;
        this.zoomExpression = zoomExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ZOOM_EXPRESSION, old, this.zoomExpression);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardMapComponent standardMapComponent = this;
        synchronized (standardMapComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        StandardMapComponent clone = null;
        try {
            clone = (StandardMapComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.latitudeExpression = JRCloneUtils.nullSafeClone(this.latitudeExpression);
        clone.longitudeExpression = JRCloneUtils.nullSafeClone(this.longitudeExpression);
        clone.zoomExpression = JRCloneUtils.nullSafeClone(this.zoomExpression);
        clone.eventSupport = null;
        return clone;
    }
}

