/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;

public class MethodParameter {
    private Method method;
    private Constructor constructor;
    private final int parameterIndex;
    private Class parameterType;
    private Object[] parameterAnnotations;
    private int nestingLevel;
    private Map typeIndexesPerLevel;

    public MethodParameter(Method method, int parameterIndex) {
        this(method, parameterIndex, 1);
    }

    public MethodParameter(Method method, int parameterIndex, int nestingLevel) {
        Assert.notNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public MethodParameter(Constructor constructor, int parameterIndex) {
        this(constructor, parameterIndex, 1);
    }

    public MethodParameter(Constructor constructor, int parameterIndex, int nestingLevel) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.constructor = constructor;
        this.parameterIndex = parameterIndex;
        this.nestingLevel = nestingLevel;
    }

    public Method getMethod() {
        return this.method;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Class getParameterType() {
        if (this.parameterType == null) {
            this.parameterType = this.method != null ? this.method.getParameterTypes()[this.parameterIndex] : this.constructor.getParameterTypes()[this.parameterIndex];
        }
        return this.parameterType;
    }

    public Object[] getParameterAnnotations() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = this.method != null ? this.method.getParameterAnnotations()[this.parameterIndex] : this.constructor.getParameterAnnotations()[this.parameterIndex];
        }
        return this.parameterAnnotations;
    }

    public void increaseNestingLevel() {
        ++this.nestingLevel;
    }

    public void decreaseNestingLevel() {
        this.getTypeIndexesPerLevel().remove(new Integer(this.nestingLevel));
        --this.nestingLevel;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public void setTypeIndexForCurrentLevel(int typeIndex) {
        this.getTypeIndexesPerLevel().put(new Integer(this.nestingLevel), new Integer(typeIndex));
    }

    public Integer getTypeIndexForCurrentLevel() {
        return this.getTypeIndexForLevel(this.nestingLevel);
    }

    public Integer getTypeIndexForLevel(int nestingLevel) {
        return (Integer)this.getTypeIndexesPerLevel().get(new Integer(nestingLevel));
    }

    private Map getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap(4);
        }
        return this.typeIndexesPerLevel;
    }

    public static MethodParameter forMethodOrConstructor(Object methodOrConstructor, int parameterIndex) {
        if (methodOrConstructor instanceof Method) {
            return new MethodParameter((Method)methodOrConstructor, parameterIndex);
        }
        if (methodOrConstructor instanceof Constructor) {
            return new MethodParameter((Constructor)methodOrConstructor, parameterIndex);
        }
        throw new IllegalArgumentException("Given object [" + methodOrConstructor + "] is neither a Method nor a Constructor");
    }
}

