/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

public class LazyInteger
extends LazyPrimitive<LazyIntObjectInspector, IntWritable> {
    public LazyInteger(LazyIntObjectInspector oi) {
        super(oi);
        this.data = new IntWritable();
    }

    public LazyInteger(LazyInteger copy) {
        super(copy);
        this.data = new IntWritable(((IntWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        try {
            ((IntWritable)this.data).set(LazyInteger.parseInt(bytes.getData(), start, length, 10));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
        }
    }

    public static int parseInt(byte[] bytes, int start, int length) {
        return LazyInteger.parseInt(bytes, start, length, 10);
    }

    public static int parseInt(byte[] bytes, int start, int length, int radix) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (length == 0) {
            throw new NumberFormatException("Empty string!");
        }
        int offset = start;
        boolean bl = negative = bytes[start] == 45;
        if (negative || bytes[start] == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
        }
        return LazyInteger.parse(bytes, start, length, offset, radix, negative);
    }

    private static int parse(byte[] bytes, int start, int length, int offset, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int end = start + length;
        while (offset < end) {
            int digit;
            if ((digit = LazyUtils.digit(bytes[offset++], radix)) == -1) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            if (max > result) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
        }
        return result;
    }

    public static void writeUTF8(OutputStream out, int i) throws IOException {
        boolean negative;
        if (i == 0) {
            out.write(48);
            return;
        }
        boolean bl = negative = i < 0;
        if (negative) {
            out.write(45);
        } else {
            i = -i;
        }
        int start = 1000000000;
        while (i / start == 0) {
            start /= 10;
        }
        while (start > 0) {
            out.write(48 - i / start % 10);
            start /= 10;
        }
    }

    public static void writeUTF8NoException(OutputStream out, int i) {
        try {
            LazyInteger.writeUTF8(out, i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

