/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBMetaDataFactory {
    private static Logger LOGGER = Logger.getLogger(DBMetaDataFactory.class.getName());
    public static final int DB2 = 0;
    public static final int ORACLE = 1;
    public static final int SQLSERVER = 2;
    public static final int JDBC = 3;
    public static final int PostgreSQL = 4;
    public static final int MYSQL = 5;
    public static final int DERBY = 6;
    public static final int SYBASE = 7;
    public static final int AXION = 8;
    private Connection dbconn;
    private int dbType = -1;
    private DatabaseMetaData dbmeta;

    public DBMetaDataFactory(Connection connection) throws SQLException {
        assert (connection != null);
        this.dbconn = connection;
        this.dbmeta = connection.getMetaData();
        this.dbType = this.getDBType();
    }

    public boolean supportsLimit() {
        switch (this.dbType) {
            case 4: 
            case 5: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getDBType() throws SQLException {
        if (this.dbType != -1) {
            return this.dbType;
        }
        if (this.dbmeta.getURL() != null) {
            return DBMetaDataFactory.getDBTypeFromURL(this.dbmeta.getURL());
        }
        return 3;
    }

    private static int getDBTypeFromURL(String string) {
        int n = -1;
        n = (string = string.toLowerCase()).indexOf("sybase") > -1 ? 7 : (string.indexOf("sqlserver") > -1 ? 2 : (string.indexOf("db2") > -1 ? 0 : (string.indexOf("orac") > -1 ? 1 : (string.indexOf("axion") > -1 ? 8 : (string.indexOf("derby") > -1 ? 6 : (string.indexOf("postgre") > -1 ? 4 : (string.indexOf("mysql") > -1 ? 5 : 3)))))));
        return n;
    }

    public Map<Integer, String> buildDBSpecificDatatypeMap() throws SQLException {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        ResultSet resultSet = this.dbmeta.getTypeInfo();
        String string = null;
        Integer n = null;
        int n2 = 0;
        while (resultSet.next()) {
            string = resultSet.getString("TYPE_NAME");
            n2 = resultSet.getInt("DATA_TYPE");
            n = new Integer(n2);
            if (hashMap.containsKey(n)) continue;
            hashMap.put(n, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBPrimaryKey getPrimaryKeys(String string, String string2, String string3) {
        ResultSet resultSet = null;
        try {
            resultSet = this.dbmeta.getPrimaryKeys(this.setToNullIfEmpty(string), this.setToNullIfEmpty(string2), string3);
            DBPrimaryKey dBPrimaryKey = new DBPrimaryKey(resultSet);
            DataViewUtils.closeResources(resultSet);
            return dBPrimaryKey;
        }
        catch (SQLException sQLException) {
            DBPrimaryKey dBPrimaryKey = null;
            return dBPrimaryKey;
        }
        finally {
            DataViewUtils.closeResources(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DBForeignKey> getForeignKeys(DBTable dBTable) {
        Map<String, DBForeignKey> map = Collections.emptyMap();
        ResultSet resultSet = null;
        try {
            resultSet = this.dbmeta.getImportedKeys(this.setToNullIfEmpty(dBTable.getCatalog()), this.setToNullIfEmpty(dBTable.getSchema()), dBTable.getName());
            map = DBForeignKey.createForeignKeyColumnMap(dBTable, resultSet);
            DataViewUtils.closeResources(resultSet);
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        finally {
            DataViewUtils.closeResources(resultSet);
        }
        return map;
    }

    public synchronized Collection<DBTable> generateDBTables(ResultSet resultSet, String string, boolean bl) throws SQLException {
        LinkedHashMap<String, DBTable> linkedHashMap = new LinkedHashMap<String, DBTable>();
        String string2 = "UNKNOWN";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String string3;
            int n;
            DBTable dBTable;
            Object object = resultSetMetaData.getTableName(i);
            if (object == null) {
                object = string2;
            }
            String object2 = resultSetMetaData.getSchemaName(i);
            String string4 = resultSetMetaData.getCatalogName(i);
            String string5 = string4 + object2 + (String)object;
            if (string5.equals("")) {
                string5 = string2;
            }
            if ((dBTable = (DBTable)linkedHashMap.get(string5)) == null) {
                dBTable = new DBTable((String)object, object2, string4);
                linkedHashMap.put(string5, dBTable);
            }
            if ((n = resultSetMetaData.getColumnType(i)) == 1111 && this.dbType == 1) {
                string3 = resultSetMetaData.getColumnTypeName(i);
                if (string3.startsWith("TIMESTAMP")) {
                    n = 93;
                } else if (string3.startsWith("FLOAT")) {
                    n = 6;
                } else if (string3.startsWith("REAL")) {
                    n = 7;
                } else if (string3.startsWith("BLOB")) {
                    n = 2004;
                } else if (string3.startsWith("CLOB")) {
                    n = 2005;
                }
            }
            string3 = resultSetMetaData.getColumnName(i);
            int n2 = i;
            int n3 = resultSetMetaData.getScale(i);
            int n4 = resultSetMetaData.getPrecision(i);
            boolean bl2 = resultSetMetaData.isNullable(i) == 1;
            String string6 = resultSetMetaData.getColumnLabel(i);
            int n5 = resultSetMetaData.getColumnDisplaySize(i);
            boolean bl3 = resultSetMetaData.isAutoIncrement(i);
            if (n == 91 && this.dbType == 1) {
                n = 93;
                n5 = 22;
            }
            if (n == -2 && this.dbType == 2 && n4 == 8) {
                bl3 = true;
            }
            DBColumn dBColumn = new DBColumn(dBTable, string3, n, n3, n4, bl2, bl3);
            dBColumn.setOrdinalPosition(n2);
            dBColumn.setDisplayName(string6);
            dBColumn.setDisplaySize(n5);
            dBTable.addColumn(dBColumn);
            dBTable.setQuoter(SQLIdentifiers.createQuoter((DatabaseMetaData)this.dbmeta));
        }
        DBTable dBTable = (DBTable)linkedHashMap.get(string2);
        if (linkedHashMap.size() == 1 && dBTable != null && bl) {
            this.adjustTableMetadata(string, (DBTable)linkedHashMap.get(string2));
            for (DBColumn dBColumn : dBTable.getColumns().values()) {
                dBColumn.setEditable(!dBTable.getName().equals("") && !dBColumn.isGenerated());
            }
        }
        for (DBTable dBTable2 : linkedHashMap.values()) {
            if (DataViewUtils.isNullString(dBTable2.getName())) continue;
            this.checkPrimaryKeys(dBTable2);
            this.checkForeignKeys(dBTable2);
        }
        return linkedHashMap.values();
    }

    private void adjustTableMetadata(String string, DBTable dBTable) {
        String[] stringArray;
        String string2 = "";
        if (string.toUpperCase().contains("FROM")) {
            StringTokenizer stringTokenizer;
            stringArray = string.toUpperCase().split("FROM");
            String string3 = string.substring(string.length() - stringArray[1].length());
            if (string3.toUpperCase().contains("WHERE")) {
                stringArray = string3.toUpperCase().split("WHERE");
                string3 = string3.substring(0, stringArray[0].length());
            }
            if ((stringTokenizer = new StringTokenizer(string3, " ,")).hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = "";
            }
        }
        if ((stringArray = string2.split("\\.")).length == 3) {
            dBTable.setCatalogName(this.unQuoteIfNeeded(stringArray[0]));
            dBTable.setSchemaName(this.unQuoteIfNeeded(stringArray[1]));
            dBTable.setName(this.unQuoteIfNeeded(stringArray[2]));
        } else if (stringArray.length == 2) {
            dBTable.setSchemaName(this.unQuoteIfNeeded(stringArray[0]));
            dBTable.setName(this.unQuoteIfNeeded(stringArray[1]));
        } else if (stringArray.length == 1) {
            dBTable.setName(this.unQuoteIfNeeded(stringArray[0]));
        }
    }

    private String unQuoteIfNeeded(String string) {
        String string2 = "\"";
        try {
            string2 = this.dbmeta.getIdentifierQuoteString().trim();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string.replaceAll(string2, "");
    }

    private void checkPrimaryKeys(DBTable dBTable) {
        DBPrimaryKey dBPrimaryKey = this.getPrimaryKeys(dBTable.getCatalog(), dBTable.getSchema(), dBTable.getName());
        if (dBPrimaryKey != null && dBPrimaryKey.getColumnCount() != 0) {
            dBTable.setPrimaryKey(dBPrimaryKey);
            List<DBColumn> list = dBTable.getColumnList();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DBColumn dBColumn = list.get(i);
                    if (!dBPrimaryKey.contains(dBColumn.getName())) continue;
                    dBColumn.setPrimaryKey(true);
                }
            }
        }
    }

    private void checkForeignKeys(DBTable dBTable) {
        Map<String, DBForeignKey> map = this.getForeignKeys(dBTable);
        if (map != null) {
            dBTable.setForeignKeyMap(map);
            HashSet<String> hashSet = new HashSet<String>();
            for (DBForeignKey list2 : map.values()) {
                if (list2 == null) continue;
                hashSet.addAll(list2.getColumnNames());
            }
            List<DBColumn> list = dBTable.getColumnList();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DBColumn dBColumn = list.get(i);
                    if (!hashSet.contains(dBColumn.getName())) continue;
                    dBColumn.setForeignKey(true);
                }
            }
        }
    }

    private String setToNullIfEmpty(String string) {
        if (string != null && string.equals("")) {
            string = null;
        }
        return string;
    }
}

