/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheck;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyUtils;

public final class AttrCheckImpl {
    public static final AttrCheck URL = new CheckUrl();
    public static final AttrCheck SCRIPT = new CheckScript();
    public static final AttrCheck NAME = new CheckName();
    public static final AttrCheck ID = new CheckId();
    public static final AttrCheck ALIGN = new CheckAlign();
    public static final AttrCheck VALIGN = new CheckValign();
    public static final AttrCheck BOOL = new CheckBool();
    public static final AttrCheck LENGTH = new CheckLength();
    public static final AttrCheck TARGET = new CheckTarget();
    public static final AttrCheck FSUBMIT = new CheckFsubmit();
    public static final AttrCheck CLEAR = new CheckClear();
    public static final AttrCheck SHAPE = new CheckShape();
    public static final AttrCheck NUMBER = new CheckNumber();
    public static final AttrCheck SCOPE = new CheckScope();
    public static final AttrCheck COLOR = new CheckColor();
    public static final AttrCheck VTYPE = new CheckVType();
    public static final AttrCheck SCROLL = new CheckScroll();
    public static final AttrCheck TEXTDIR = new CheckTextDir();
    public static final AttrCheck LANG = new CheckLang();
    public static final AttrCheck TEXT = null;
    public static final AttrCheck CHARSET = null;
    public static final AttrCheck TYPE = null;
    public static final AttrCheck CHARACTER = null;
    public static final AttrCheck URLS = null;
    public static final AttrCheck COLS = null;
    public static final AttrCheck COORDS = null;
    public static final AttrCheck DATE = null;
    public static final AttrCheck IDREF = null;
    public static final AttrCheck TFRAME = null;
    public static final AttrCheck FBORDER = null;
    public static final AttrCheck MEDIA = null;
    public static final AttrCheck LINKTYPES = null;
    public static final AttrCheck TRULES = null;

    private AttrCheckImpl() {
    }

    public static class CheckLang
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if ("lang".equals(attVal.attribute)) {
                lexer.constrainVersion(-1025);
            }
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
        }
    }

    public static class CheckTextDir
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"rtl", "ltr"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckScroll
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"no", "yes", "auto"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckVType
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"data", "object", "ref"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckColor
    implements AttrCheck {
        private static final Map COLORS = new HashMap();

        public void check(Lexer lexer, Node node, AttVal attVal) {
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            if (attVal.value == null || attVal.value.length() == 0) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            String string = attVal.value;
            Iterator iterator = COLORS.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (string.charAt(0) == '#') {
                    if (string.length() != 7) {
                        lexer.report.attrError(lexer, node, attVal, (short)51);
                        bl2 = true;
                        break;
                    }
                    if (!string.equalsIgnoreCase((String)entry.getValue())) continue;
                    if (lexer.configuration.replaceColor) {
                        attVal.value = (String)entry.getKey();
                    }
                    bl3 = true;
                    break;
                }
                if (TidyUtils.isLetter(string.charAt(0))) {
                    if (!string.equalsIgnoreCase((String)entry.getKey())) continue;
                    if (lexer.configuration.replaceColor) {
                        attVal.value = (String)entry.getKey();
                    }
                    bl3 = true;
                    break;
                }
                lexer.report.attrError(lexer, node, attVal, (short)51);
                bl2 = true;
                break;
            }
            if (!bl3 && !bl2) {
                if (string.charAt(0) == '#') {
                    int n;
                    for (n = 1; n < 7; ++n) {
                        if (TidyUtils.isDigit(string.charAt(n)) || "abcdef".indexOf(Character.toLowerCase(string.charAt(n))) != -1) continue;
                        lexer.report.attrError(lexer, node, attVal, (short)51);
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && bl) {
                        for (n = 1; n < 7; ++n) {
                            attVal.value = string.toUpperCase();
                        }
                    }
                } else {
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                    bl2 = true;
                }
            }
        }

        static {
            COLORS.put("black", "#000000");
            COLORS.put("green", "#008000");
            COLORS.put("silver", "#C0C0C0");
            COLORS.put("lime", "#00FF00");
            COLORS.put("gray", "#808080");
            COLORS.put("olive", "#808000");
            COLORS.put("white", "#FFFFFF");
            COLORS.put("yellow", "#FFFF00");
            COLORS.put("maroon", "#800000");
            COLORS.put("navy", "#000080");
            COLORS.put("red", "#FF0000");
            COLORS.put("blue", "#0000FF");
            COLORS.put("purple", "#800080");
            COLORS.put("teal", "#008080");
            COLORS.put("fuchsia", "#FF00FF");
            COLORS.put("aqua", "#00FFFF");
        }
    }

    public static class CheckName
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            if (lexer.configuration.tt.isAnchorElement(node)) {
                lexer.constrainVersion(-1025);
                Node node2 = lexer.configuration.tt.getNodeByAnchor(attVal.value);
                if (node2 != null && node2 != node) {
                    lexer.report.attrError(lexer, node, attVal, (short)66);
                } else {
                    lexer.configuration.tt.anchorList = lexer.configuration.tt.addAnchor(attVal.value, node);
                }
            }
        }
    }

    public static class CheckId
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null || attVal.value.length() == 0) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            String string = attVal.value;
            char c = string.charAt(0);
            if (string.length() == 0 || !Character.isLetter(string.charAt(0))) {
                if (lexer.isvoyager && (TidyUtils.isXMLLetter(c) || c == '_' || c == ':')) {
                    lexer.report.attrError(lexer, node, attVal, (short)71);
                } else {
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                }
            } else {
                for (int i = 1; i < string.length(); ++i) {
                    c = string.charAt(i);
                    if (TidyUtils.isNamechar(c)) continue;
                    if (lexer.isvoyager && TidyUtils.isXMLNamechar(c)) {
                        lexer.report.attrError(lexer, node, attVal, (short)71);
                        break;
                    }
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                    break;
                }
            }
            Node node2 = lexer.configuration.tt.getNodeByAnchor(attVal.value);
            if (node2 != null && node2 != node) {
                lexer.report.attrError(lexer, node, attVal, (short)66);
            } else {
                lexer.configuration.tt.anchorList = lexer.configuration.tt.addAnchor(attVal.value, node);
            }
        }
    }

    public static class CheckNumber
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            if (("cols".equalsIgnoreCase(attVal.attribute) || "rows".equalsIgnoreCase(attVal.attribute)) && node.tag == lexer.configuration.tt.tagFrameset) {
                return;
            }
            String string = attVal.value;
            int n = 0;
            if (node.tag == lexer.configuration.tt.tagFont && (string.startsWith("+") || string.startsWith("-"))) {
                ++n;
            }
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isDigit(c)) {
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                    break;
                }
                ++n;
            }
        }
    }

    public static class CheckScope
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"row", "rowgroup", "col", "colgroup"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckShape
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"rect", "default", "circle", "poly"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckClear
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"none", "left", "right", "all"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                attVal.value = VALID_VALUES[0];
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckFsubmit
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"get", "post"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckTarget
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"_blank", "_self", "_parent", "_top"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            lexer.constrainVersion(-5);
            if (attVal.value == null || attVal.value.length() == 0) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            String string = attVal.value;
            if (Character.isLetter(string.charAt(0))) {
                return;
            }
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, string)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckLength
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            if ("width".equalsIgnoreCase(attVal.attribute) && (node.tag == lexer.configuration.tt.tagCol || node.tag == lexer.configuration.tt.tagColgroup)) {
                return;
            }
            String string = attVal.value;
            if (string.length() == 0 || !Character.isDigit(string.charAt(0)) && '%' != string.charAt(0)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            } else {
                TagTable tagTable = lexer.configuration.tt;
                for (int i = 1; i < string.length(); ++i) {
                    if ((Character.isDigit(string.charAt(i)) || node.tag != tagTable.tagTd && node.tag != tagTable.tagTh) && (Character.isDigit(string.charAt(i)) || string.charAt(i) == '%')) continue;
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                    break;
                }
            }
        }
    }

    public static class CheckBool
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
        }
    }

    public static class CheckValign
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"top", "middle", "bottom", "baseline"};
        private static final String[] VALID_VALUES_IMG = new String[]{"left", "right"};
        private static final String[] VALID_VALUES_PROPRIETARY = new String[]{"texttop", "absmiddle", "absbottom", "textbottom"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            String string = attVal.value;
            if (TidyUtils.isInValuesIgnoreCase(VALID_VALUES, string)) {
                return;
            }
            if (TidyUtils.isInValuesIgnoreCase(VALID_VALUES_IMG, string)) {
                if (node.tag == null || (node.tag.model & 0x10000) == 0) {
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                }
            } else if (TidyUtils.isInValuesIgnoreCase(VALID_VALUES_PROPRIETARY, string)) {
                lexer.constrainVersion(448);
                lexer.report.attrError(lexer, node, attVal, (short)54);
            } else {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckAlign
    implements AttrCheck {
        private static final String[] VALID_VALUES = new String[]{"left", "center", "right", "justify"};

        public void check(Lexer lexer, Node node, AttVal attVal) {
            if (node.tag != null && (node.tag.model & 0x10000) != 0) {
                VALIGN.check(lexer, node, attVal);
                return;
            }
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            attVal.checkLowerCaseAttrValue(lexer, node);
            if (!TidyUtils.isInValuesIgnoreCase(VALID_VALUES, attVal.value)) {
                lexer.report.attrError(lexer, node, attVal, (short)51);
            }
        }
    }

    public static class CheckScript
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
        }
    }

    public static class CheckUrl
    implements AttrCheck {
        public void check(Lexer lexer, Node node, AttVal attVal) {
            char c;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            if (attVal.value == null) {
                lexer.report.attrError(lexer, node, attVal, (short)50);
                return;
            }
            String string = attVal.value;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c <= '~' && c > ' ' && c != '<' && c != '>') continue;
                bl = true;
            }
            if (lexer.configuration.fixBackslash && bl2) {
                string = attVal.value = attVal.value.replace('\\', '/');
            }
            if (lexer.configuration.fixUri && bl) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < string.length(); ++n) {
                    c = string.charAt(n);
                    if (c > '~' || c <= ' ' || c == '<' || c == '>') {
                        stringBuffer.append('%');
                        stringBuffer.append(Integer.toHexString(c).toUpperCase());
                        continue;
                    }
                    stringBuffer.append(c);
                }
                attVal.value = stringBuffer.toString();
            }
            if (bl2) {
                if (lexer.configuration.fixBackslash) {
                    lexer.report.attrError(lexer, node, attVal, (short)62);
                } else {
                    lexer.report.attrError(lexer, node, attVal, (short)61);
                }
            }
            if (bl) {
                if (lexer.configuration.fixUri) {
                    lexer.report.attrError(lexer, node, attVal, (short)64);
                } else {
                    lexer.report.attrError(lexer, node, attVal, (short)63);
                }
                lexer.badChars = (short)(lexer.badChars | 0x51);
            }
        }
    }
}

