/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.ConnectionHeader;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.Status;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class Client {
    public static final Log LOG = LogFactory.getLog(Client.class);
    private Hashtable<ConnectionId, Connection> connections = new Hashtable();
    private Class<? extends Writable> valueClass;
    private int counter;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final Configuration conf;
    private final int maxIdleTime;
    private final int maxRetries;
    private boolean tcpNoDelay;
    private int pingInterval;
    private SocketFactory socketFactory;
    private int refCount = 1;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int PING_CALL_ID = -1;

    public static final void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static final int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.maxIdleTime = conf.getInt("ipc.client.connection.maxidletime", 10000);
        this.maxRetries = conf.getInt("ipc.client.connect.max.retries", 10);
        this.tcpNoDelay = conf.getBoolean("ipc.client.tcpnodelay", false);
        this.pingInterval = Client.getPingInterval(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The ping interval is" + this.pingInterval + "ms."));
        }
        this.conf = conf;
        this.socketFactory = factory;
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress address) throws InterruptedException, IOException {
        return this.call(param, address, null);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, UserGroupInformation ticket) throws InterruptedException, IOException {
        return this.call(param, addr, null, ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket) throws InterruptedException, IOException {
        Call call = new Call(param);
        Connection connection = this.getConnection(addr, protocol, ticket, call);
        connection.sendParam(call);
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return call.value;
        }
    }

    private IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    @Deprecated
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException {
        return this.call(params, addresses, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses, Class<?> protocol, UserGroupInformation ticket) throws IOException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    Connection connection = this.getConnection(addresses[i], protocol, ticket, call);
                    connection.sendParam(call);
                    continue;
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + e.getMessage()), (Throwable)e);
                    results.size--;
                }
            }
            while (results.count != results.size) {
                try {
                    results.wait();
                }
                catch (InterruptedException e) {}
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, Call call) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        ConnectionId remoteId = new ConnectionId(addr, protocol, ticket);
        do {
            Hashtable<ConnectionId, Connection> hashtable = this.connections;
            synchronized (hashtable) {
                connection = this.connections.get(remoteId);
                if (connection == null) {
                    connection = new Connection(remoteId);
                    this.connections.put(remoteId, connection);
                }
            }
        } while (!connection.addCall(call));
        connection.setupIOstreams();
        return connection;
    }

    private static class ConnectionId {
        InetSocketAddress address;
        UserGroupInformation ticket;
        Class<?> protocol;
        private static final int PRIME = 16777619;

        ConnectionId(InetSocketAddress address, Class<?> protocol, UserGroupInformation ticket) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.protocol == id.protocol && this.ticket == id.ticket;
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode() + 16777619 * System.identityHashCode(this.protocol) ^ System.identityHashCode(this.ticket);
        }
    }

    private static class ParallelResults {
        private Writable[] values;
        private int size;
        private int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        public synchronized void callComplete(ParallelCall call) {
            this.values[((ParallelCall)call).index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private ParallelResults results;
        private int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        @Override
        protected void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress server;
        private ConnectionHeader header;
        private ConnectionId remoteId;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private AtomicLong lastActivity = new AtomicLong();
        private AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;

        public Connection(ConnectionId remoteId) throws IOException {
            this.remoteId = remoteId;
            this.server = remoteId.getAddress();
            if (this.server.isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            UserGroupInformation ticket = remoteId.getTicket();
            Class<?> protocol = remoteId.getProtocol();
            this.header = new ConnectionHeader(protocol == null ? null : protocol.getName(), ticket);
            this.setName("IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + " from " + (ticket == null ? "an unknown user" : ticket.getUserName()));
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        private synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        private synchronized void setupIOstreams() {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            int ioFailures = 0;
            int timeoutFailures = 0;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connecting to " + this.server));
                }
                while (true) {
                    try {
                        this.socket = Client.this.socketFactory.createSocket();
                        this.socket.setTcpNoDelay(Client.this.tcpNoDelay);
                        NetUtils.connect(this.socket, this.remoteId.getAddress(), 20000);
                        this.socket.setSoTimeout(Client.this.pingInterval);
                    }
                    catch (SocketTimeoutException toe) {
                        int n = timeoutFailures;
                        timeoutFailures = (short)(timeoutFailures + 1);
                        this.handleConnectionFailure(n, 45, toe);
                        continue;
                    }
                    catch (IOException ie) {
                        int n = ioFailures;
                        ioFailures = (short)(ioFailures + 1);
                        this.handleConnectionFailure(n, Client.this.maxRetries, ie);
                        continue;
                    }
                    break;
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream(NetUtils.getInputStream(this.socket))));
                this.out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.socket)));
                this.writeHeader();
                this.touch();
                this.start();
            }
            catch (IOException e) {
                this.markClosed(e);
                this.close();
            }
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s)."));
        }

        private void writeHeader() throws IOException {
            this.out.write(Server.HEADER.array());
            this.out.write(3);
            DataOutputBuffer buf = new DataOutputBuffer();
            this.header.write(buf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get() && (timeout = (long)Client.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)Client.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, having connections " + Client.this.connections.size()));
            }
            while (this.waitForWork()) {
                this.receiveResponse();
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, remaining connections " + Client.this.connections.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendParam(Call call) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            DataOutputBuffer d = null;
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + " sending #" + call.id));
                    }
                    d = new DataOutputBuffer();
                    d.writeInt(call.id);
                    call.param.write(d);
                    byte[] data = d.getData();
                    int dataLength = d.getLength();
                    this.out.writeInt(dataLength);
                    this.out.write(data, 0, dataLength);
                    this.out.flush();
                }
                IOUtils.closeStream(d);
            }
            catch (IOException e) {
                this.markClosed(e);
            }
            finally {
                IOUtils.closeStream(d);
            }
        }

        private void receiveResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int id = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + id));
                }
                Call call = this.calls.get(id);
                int state = this.in.readInt();
                if (state == Status.SUCCESS.state) {
                    Writable value = (Writable)ReflectionUtils.newInstance(Client.this.valueClass, Client.this.conf);
                    value.readFields(this.in);
                    call.setValue(value);
                    this.calls.remove(id);
                } else if (state == Status.ERROR.state) {
                    call.setException(new RemoteException(WritableUtils.readString(this.in), WritableUtils.readString(this.in)));
                } else if (state == Status.FATAL.state) {
                    this.markClosed(new RemoteException(WritableUtils.readString(this.in), WritableUtils.readString(this.in)));
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            Hashtable hashtable = Client.this.connections;
            synchronized (hashtable) {
                if (Client.this.connections.get(this.remoteId) == this) {
                    Client.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream(this.out);
            IOUtils.closeStream(this.in);
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                c.setException(this.closeException);
                itor.remove();
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !Client.this.running.get()) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class Call {
        int id;
        Writable param;
        Writable value;
        IOException error;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            Client client2 = Client.this;
            synchronized (client2) {
                this.id = Client.this.counter++;
            }
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setValue(Writable value) {
            this.value = value;
            this.callComplete();
        }
    }
}

