/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.tools.FieldPatternDialog;
import com.jaspersoft.ireport.designer.tools.LocaleSelectorDialog;
import com.jaspersoft.ireport.designer.tools.TimeZoneDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.jrx.JRXMLDataSourceConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class JRXMLDataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private Locale tmpXMLLocale = null;
    private TimeZone tmpXMLTimeZone = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonXMLDatePattern;
    private JButton jButtonXMLLocale;
    private JButton jButtonXMLNumberPattern;
    private JButton jButtonXMLTimeZone;
    private JLabel jLabel9;
    private JLabel jLabelXMLDatePattern;
    private JLabel jLabelXMLLocale;
    private JLabel jLabelXMLNumberPattern;
    private JLabel jLabelXMLTimeZone;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanelXML;
    private JSeparator jSeparator9;
    private JTextField jTextFieldXMLDatePattern;
    private JTextField jTextFieldXMLFile;
    private JTextField jTextFieldXMLLocaleValue;
    private JTextField jTextFieldXMLNumberPattern;
    private JTextField jTextFieldXMLTimeZoneValue;

    public JRXMLDataSourceConnectionEditor() {
        this.initComponents();
        this.applyI18n();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanelXML = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jTextFieldXMLFile = new JTextField();
        this.jSeparator9 = new JSeparator();
        this.jLabelXMLDatePattern = new JLabel();
        this.jTextFieldXMLDatePattern = new JTextField();
        this.jButtonXMLDatePattern = new JButton();
        this.jLabelXMLNumberPattern = new JLabel();
        this.jTextFieldXMLNumberPattern = new JTextField();
        this.jButtonXMLNumberPattern = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabelXMLLocale = new JLabel();
        this.jTextFieldXMLLocaleValue = new JTextField();
        this.jLabelXMLTimeZone = new JLabel();
        this.jButtonXMLLocale = new JButton();
        this.jTextFieldXMLTimeZoneValue = new JTextField();
        this.jButtonXMLTimeZone = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanelXML.setLayout(new GridBagLayout());
        this.jPanelXML.setPreferredSize(new Dimension(1, 30));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel9.setText("XML URL");
        this.jLabel9.setMinimumSize(new Dimension(20, 14));
        this.jLabel9.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jTextFieldXMLFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelXML.add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator9.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 4);
        this.jPanelXML.add((Component)this.jSeparator9, gridBagConstraints);
        this.jLabelXMLDatePattern.setText("Date pattern");
        this.jLabelXMLDatePattern.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jLabelXMLDatePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelXML.add((Component)this.jTextFieldXMLDatePattern, gridBagConstraints);
        this.jButtonXMLDatePattern.setText("Create");
        this.jButtonXMLDatePattern.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLDatePattern.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLDatePattern.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLDatePattern.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLDatePattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButton2ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 7);
        this.jPanelXML.add((Component)this.jButtonXMLDatePattern, gridBagConstraints);
        this.jLabelXMLNumberPattern.setText("Number pattern");
        this.jLabelXMLNumberPattern.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.jPanelXML.add((Component)this.jLabelXMLNumberPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.jPanelXML.add((Component)this.jTextFieldXMLNumberPattern, gridBagConstraints);
        this.jButtonXMLNumberPattern.setText("Create");
        this.jButtonXMLNumberPattern.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLNumberPattern.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLNumberPattern.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLNumberPattern.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLNumberPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePatternjButton2ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(1, 3, 3, 7);
        this.jPanelXML.add((Component)this.jButtonXMLNumberPattern, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Locale / Time zone"));
        this.jLabelXMLLocale.setText("Locale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelXMLLocale, gridBagConstraints);
        this.jTextFieldXMLLocaleValue.setEditable(false);
        this.jTextFieldXMLLocaleValue.setText("Default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldXMLLocaleValue, gridBagConstraints);
        this.jLabelXMLTimeZone.setText("Time zone");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelXMLTimeZone, gridBagConstraints);
        this.jButtonXMLLocale.setText("Select...");
        this.jButtonXMLLocale.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLLocale.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLLocale.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLLocale.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePatternjButton2ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 8);
        this.jPanel3.add((Component)this.jButtonXMLLocale, gridBagConstraints);
        this.jTextFieldXMLTimeZoneValue.setEditable(false);
        this.jTextFieldXMLTimeZoneValue.setText("Default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldXMLTimeZoneValue, gridBagConstraints);
        this.jButtonXMLTimeZone.setText("Select...");
        this.jButtonXMLTimeZone.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonXMLTimeZone.setMaximumSize(new Dimension(100, 25));
        this.jButtonXMLTimeZone.setMinimumSize(new Dimension(70, 25));
        this.jButtonXMLTimeZone.setPreferredSize(new Dimension(70, 25));
        this.jButtonXMLTimeZone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRXMLDataSourceConnectionEditor.this.jButtonXMLDatePattern1jButtonXMLDatePatternjButton2ActionPerformed11(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new Insets(0, 0, 4, 8);
        this.jPanel3.add((Component)this.jButtonXMLTimeZone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 3, 0, 4);
        this.jPanelXML.add((Component)this.jPanel3, gridBagConstraints);
        this.add((Component)this.jPanelXML, "Center");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(Misc.findStartingDirectory());
        jfc.setDialogTitle("Select XML file....");
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "XML *.xml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldXMLFile.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jButtonXMLDatePattern1jButtonXMLDatePatternjButton2ActionPerformed11(ActionEvent evt) {
        TimeZoneDialog lsd = new TimeZoneDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        if (this.tmpXMLTimeZone != null) {
            lsd.setReportTimeZoneId(this.tmpXMLTimeZone.getID());
        }
        lsd.setVisible(true);
        if (lsd.getDialogResult() == 0) {
            if (lsd.getReportTimeZoneId() == null) {
                this.tmpXMLTimeZone = null;
                this.jTextFieldXMLTimeZoneValue.setText(I18n.getString((String)"timezone.default"));
            } else {
                this.tmpXMLTimeZone = TimeZone.getTimeZone(lsd.getReportTimeZoneId());
                this.jTextFieldXMLTimeZoneValue.setText(this.tmpXMLTimeZone.getDisplayName(Locale.getDefault()));
            }
        }
    }

    private void jButtonXMLDatePatternjButton2ActionPerformed11(ActionEvent evt) {
        LocaleSelectorDialog lsd = new LocaleSelectorDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        if (this.tmpXMLLocale != null) {
            lsd.setSelectedLocale(this.tmpXMLLocale);
        }
        lsd.setVisible(true);
        if (lsd.getDialogResult() == 0) {
            this.tmpXMLLocale = lsd.getSelectedLocale();
            this.jTextFieldXMLLocaleValue.setText(this.tmpXMLLocale == null ? I18n.getString((String)"timezone.default") : this.tmpXMLLocale.getDisplayName(Locale.getDefault()));
        }
    }

    private void jButtonXMLDatePatternjButton2ActionPerformed1(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyNumbers(true);
        if (this.jTextFieldXMLNumberPattern.getText().length() > 0) {
            fpd.setPattern(this.jTextFieldXMLNumberPattern.getText());
        }
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldXMLNumberPattern.setText(fpd.getPattern());
        }
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyDate(true);
        if (this.jTextFieldXMLDatePattern.getText().length() > 0) {
            fpd.setPattern(this.jTextFieldXMLDatePattern.getText());
        }
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldXMLDatePattern.setText(fpd.getPattern());
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRXMLDataSourceConnection) {
            JRXMLDataSourceConnection con = (JRXMLDataSourceConnection)this.iReportConnection;
            this.jTextFieldXMLFile.setText(con.getFilename());
            this.jTextFieldXMLDatePattern.setText(Misc.nvl((Object)con.getDatePattern(), (String)""));
            this.jTextFieldXMLNumberPattern.setText(Misc.nvl((Object)con.getNumberPattern(), (String)""));
            this.tmpXMLLocale = con.getLocale();
            if (this.tmpXMLLocale != null) {
                this.jTextFieldXMLLocaleValue.setText(this.tmpXMLLocale.getDisplayName(Locale.getDefault()));
            } else {
                this.jTextFieldXMLLocaleValue.setText(I18n.getString((String)"timezone.default"));
            }
            this.tmpXMLTimeZone = con.getTimeZone();
            if (this.tmpXMLTimeZone != null) {
                this.jTextFieldXMLTimeZoneValue.setText(this.tmpXMLTimeZone.getDisplayName(Locale.getDefault()));
            } else {
                this.jTextFieldXMLTimeZoneValue.setText(I18n.getString((String)"timezone.default"));
            }
        }
    }

    public IReportConnection getIReportConnection() {
        JRXMLDataSourceConnection irConn = new JRXMLDataSourceConnection();
        irConn.setFilename(this.jTextFieldXMLFile.getText().trim());
        irConn.setUseConnection(true);
        irConn.setDatePattern(this.jTextFieldXMLDatePattern.getText());
        irConn.setNumberPattern(this.jTextFieldXMLNumberPattern.getText());
        irConn.setLocale(this.tmpXMLLocale);
        irConn.setTimeZone(this.tmpXMLTimeZone);
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    public void applyI18n() {
        this.jTextFieldXMLTimeZoneValue.setText(I18n.getString((String)"timezone.default"));
        this.jTextFieldXMLLocaleValue.setText(I18n.getString((String)"timezone.default"));
        ((TitledBorder)this.jPanel3.getBorder()).setTitle(I18n.getString((String)"connectionDialog.borderXMLLocaleTimeZone", (Object)"Locale / Time zone"));
        this.jLabelXMLLocale.setText(I18n.getString((String)"connectionDialog.labelXMLLocale"));
        this.jLabelXMLTimeZone.setText(I18n.getString((String)"connectionDialog.labelXMLTimeZone"));
        this.jLabelXMLDatePattern.setText(I18n.getString((String)"connectionDialog.labelXMLDatePattern"));
        this.jLabelXMLNumberPattern.setText(I18n.getString((String)"connectionDialog.labelXMLNumberPattern"));
        this.jButtonXMLDatePattern.setText(I18n.getString((String)"connectionDialog.buttonXMLDatePattern"));
        this.jButtonXMLNumberPattern.setText(I18n.getString((String)"connectionDialog.buttonXMLNumberPattern"));
        this.jButtonXMLLocale.setText(I18n.getString((String)"connectionDialog.buttonXMLLocale"));
        this.jButtonXMLTimeZone.setText(I18n.getString((String)"connectionDialog.buttonXMLTimeZone"));
    }
}

