/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.hadoop.hive.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.hadoop.hive.connection.HiveConnectionEditor;
import com.jaspersoft.ireport.hadoop.hive.designer.HiveFieldsProvider;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.openide.util.NbBundle;

public class HiveConnection
extends IReportConnection
implements WizardFieldsProvider {
    private static final String URL = "HiveURL";
    private String url;

    public HiveConnection() {
        this.setName(NbBundle.getMessage(HiveConnection.class, (String)"connectionName"));
    }

    public String getDescription() {
        return NbBundle.getMessage(HiveConnection.class, (String)"connectionType");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new HiveConnectionEditor();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Connection getConnection() {
        try {
            return new com.jaspersoft.hadoop.hive.HiveConnection(this.url);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        com.jaspersoft.hadoop.hive.HiveConnection connection = null;
        boolean success = false;
        String message = "";
        try {
            connection = new com.jaspersoft.hadoop.hive.HiveConnection(this.url);
            success = connection.test();
        }
        catch (Exception e) {
            success = false;
            message = e.getMessage();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!success) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test failed!\n" + message, "", 0);
        } else {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
        }
    }

    public String designQuery(String query) {
        return query;
    }

    public String getQueryLanguage() {
        return "HiveQL";
    }

    public boolean supportsDesign() {
        return false;
    }

    public boolean isJDBCConnection() {
        return true;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public void loadProperties(HashMap map) {
        this.setUrl((String)map.get(URL));
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(URL, this.getUrl());
        return map;
    }

    public List<JRDesignField> readFields(String query) throws Exception {
        HiveFieldsProvider provider = new HiveFieldsProvider();
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JRDesignDataset dataset = new JRDesignDataset(true);
        JRDesignQuery designQuery = new JRDesignQuery();
        designQuery.setLanguage("HiveQL");
        designQuery.setText(query);
        dataset.setQuery(designQuery);
        JRField[] fields = provider.getFields(this, (JRDataset)dataset, new HashMap());
        for (int i = 0; i < fields.length; ++i) {
            result.add((JRDesignField)fields[i]);
        }
        return result;
    }
}

