/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Util;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapMember;

class RolapAllCubeMember
extends RolapCubeMember {
    protected final String name;
    private final String uniqueName;

    public RolapAllCubeMember(RolapMember member, RolapCubeLevel cubeLevel) {
        super(null, member, cubeLevel);
        assert (member.isAll());
        if (member.getHierarchy().getName().equals(this.getHierarchy().getName())) {
            this.name = member.getName();
        } else {
            String replacement = this.getHierarchy().getName().replaceAll("\\$", "\\\\\\$");
            String memberLevelName = member.getHierarchy().getName().replaceAll("\\.", "\\\\.");
            this.name = member.getName().replaceAll(memberLevelName, replacement);
        }
        this.uniqueName = this.getHierarchy().getName().equals(this.getDimension().getName()) ? Util.makeFqName(this.getDimension(), this.name) : Util.makeFqName(this.getHierarchy(), this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }
}

