/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontExtensionHelper;
import net.sf.jasperreports.extensions.ExtensionsRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontExtensionsRegistry
implements ExtensionsRegistry {
    private final List<String> fontFamiliesLocations;
    private List<FontFamily> fontFamilies;

    public FontExtensionsRegistry(List<String> fontFamiliesLocations) {
        this.fontFamiliesLocations = fontFamiliesLocations;
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (FontFamily.class.equals(extensionType)) {
            if (this.fontFamilies == null && this.fontFamiliesLocations != null) {
                this.fontFamilies = new ArrayList<FontFamily>();
                for (String location : this.fontFamiliesLocations) {
                    this.fontFamilies.addAll(SimpleFontExtensionHelper.getInstance().loadFontFamilies(location));
                }
            }
            return this.fontFamilies;
        }
        return null;
    }
}

