/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;

public class JDBCStatsPublisher
implements StatsPublisher {
    private Connection conn;
    private String connectionString;
    private Configuration hiveconf;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private PreparedStatement selStmt = null;
    private PreparedStatement updStmt = null;
    private PreparedStatement insStmt = null;
    private int timeout = 30;

    @Override
    public boolean connect(Configuration hiveconf) {
        try {
            this.hiveconf = hiveconf;
            this.connectionString = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
            this.timeout = HiveConf.getIntVar(hiveconf, HiveConf.ConfVars.HIVE_STATS_JDBC_TIMEOUT);
            String driver = HiveConf.getVar(hiveconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
            Class.forName(driver).newInstance();
            DriverManager.setLoginTimeout(this.timeout);
            this.conn = DriverManager.getConnection(this.connectionString);
            String select = "SELECT ROW_COUNT FROM PARTITION_STAT_TBL WHERE ID = ?";
            String update = "UPDATE PARTITION_STAT_TBL SET ROW_COUNT= ?  WHERE ID = ?";
            String insert = "INSERT INTO PARTITION_STAT_TBL VALUES (?, ?)";
            this.selStmt = this.conn.prepareStatement(select);
            this.updStmt = this.conn.prepareStatement(update);
            this.insStmt = this.conn.prepareStatement(insert);
            this.selStmt.setQueryTimeout(this.timeout);
            this.updStmt.setQueryTimeout(this.timeout);
            this.insStmt.setQueryTimeout(this.timeout);
            return true;
        }
        catch (Exception e) {
            this.LOG.error((Object)("Error during JDBC connection to " + this.connectionString + ". "), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean publishStat(String fileID, String statType, String value) {
        if (this.conn == null) {
            this.LOG.error((Object)"JDBC connection is null. Cannot publish stats without JDBC connection.");
            return false;
        }
        if (statType != "numRows") {
            this.LOG.warn((Object)"Warning. Invalid statistic. Currently row count is the only supported statistic");
            return false;
        }
        this.LOG.info((Object)("Stats publishing for key " + fileID + ". Value = " + value));
        try {
            this.selStmt.setString(1, fileID);
            ResultSet result = this.selStmt.executeQuery();
            if (result.next()) {
                long currval = result.getLong(1);
                if (currval < Long.parseLong(value)) {
                    this.updStmt.setString(1, value);
                    this.updStmt.setString(2, fileID);
                    this.updStmt.executeUpdate();
                }
            } else {
                this.insStmt.setString(1, fileID);
                this.insStmt.setString(2, value);
                this.insStmt.executeUpdate();
            }
            return true;
        }
        catch (SQLException e) {
            this.LOG.error((Object)"Error during publishing statistics. ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean closeConnection() {
        if (this.conn == null) {
            return true;
        }
        try {
            if (this.insStmt != null) {
                this.insStmt.close();
            }
            if (this.updStmt != null) {
                this.updStmt.close();
            }
            if (this.selStmt != null) {
                this.selStmt.close();
            }
            this.conn.close();
            if (HiveConf.getVar(this.hiveconf, HiveConf.ConfVars.HIVESTATSDBCLASS).equalsIgnoreCase("jdbc:derby")) {
                try {
                    DriverManager.getConnection(this.connectionString + ";shutdown=true");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            this.LOG.error((Object)"Error during JDBC termination. ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean init(Configuration hconf) {
        try {
            this.hiveconf = hconf;
            this.connectionString = HiveConf.getVar(hconf, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING);
            String driver = HiveConf.getVar(hconf, HiveConf.ConfVars.HIVESTATSJDBCDRIVER);
            Class.forName(driver).newInstance();
            DriverManager.setLoginTimeout(this.timeout);
            this.conn = DriverManager.getConnection(this.connectionString);
            Statement stmt = this.conn.createStatement();
            stmt.setQueryTimeout(this.timeout);
            DatabaseMetaData dbm = this.conn.getMetaData();
            ResultSet rs = dbm.getTables(null, null, "PARTITION_STAT_TBL", null);
            boolean tblExists = rs.next();
            if (!tblExists) {
                String createTable = "CREATE TABLE PARTITION_STAT_TBL (ID VARCHAR(255), ROW_COUNT BIGINT)";
                stmt.executeUpdate(createTable);
                stmt.close();
            }
            this.closeConnection();
        }
        catch (Exception e) {
            this.LOG.error((Object)"Error during JDBC initialization. ", (Throwable)e);
            return false;
        }
        return true;
    }
}

