/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;

public class ConditionalResolverCommonJoin
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverCommonJoinCtx ctx = (ConditionalResolverCommonJoinCtx)objCtx;
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        HashMap<String, String> aliasToPath = ctx.getAliasToPath();
        String bigTableAlias = this.resolveMapJoinTask(aliasToPath, conf);
        if (bigTableAlias == null) {
            resTsks.add(ctx.getCommonJoinTask());
        } else {
            Task<? extends Serializable> task = ctx.getAliasToTask().get(bigTableAlias);
            if (task.getTaskTag() == 3) {
                task.getBackupTask().setTaskTag(4);
            }
            resTsks.add(task);
        }
        return resTsks;
    }

    private String resolveMapJoinTask(HashMap<String, String> aliasToPath, HiveConf conf) {
        if (aliasToPath.size() == 0) {
            return null;
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        ArrayList<Long> fileSizeList = new ArrayList<Long>();
        try {
            for (Map.Entry<String, String> entry : aliasToPath.entrySet()) {
                String alias = entry.getKey();
                String pathStr = entry.getValue();
                Path path = new Path(pathStr);
                FileSystem fs = path.getFileSystem((Configuration)conf);
                FileStatus[] fstatus = fs.listStatus(path);
                long fileSize = 0L;
                for (int i = 0; i < fstatus.length; ++i) {
                    fileSize += fstatus[i].getLen();
                }
                aliasList.add(alias);
                fileSizeList.add(fileSize);
            }
            ArrayList sortedList = new ArrayList(fileSizeList);
            Collections.sort(sortedList);
            long bigTableFileSize = 0L;
            long smallTablesFileSizeSum = 0L;
            String bigTableFileAlias = null;
            int size = sortedList.size();
            for (int index = 0; index < sortedList.size(); ++index) {
                Long key = (Long)sortedList.get(index);
                if (index != size - 1) {
                    smallTablesFileSizeSum += key.longValue();
                    continue;
                }
                int tmpIndex = fileSizeList.indexOf(key);
                String alias = (String)aliasList.get(tmpIndex);
                bigTableFileSize += key.longValue();
                bigTableFileAlias = alias;
            }
            long threshold = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            if (smallTablesFileSizeSum <= threshold) {
                return bigTableFileAlias;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ConditionalResolverCommonJoinCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<String, Task<? extends Serializable>> aliasToTask;
        private HashMap<String, String> aliasToPath;
        private Task<? extends Serializable> commonJoinTask;

        public HashMap<String, Task<? extends Serializable>> getAliasToTask() {
            return this.aliasToTask;
        }

        public void setAliasToTask(HashMap<String, Task<? extends Serializable>> aliasToTask) {
            this.aliasToTask = aliasToTask;
        }

        public HashMap<String, String> getAliasToPath() {
            return this.aliasToPath;
        }

        public void setAliasToPath(HashMap<String, String> aliasToPath) {
            this.aliasToPath = aliasToPath;
        }

        public Task<? extends Serializable> getCommonJoinTask() {
            return this.commonJoinTask;
        }

        public void setCommonJoinTask(Task<? extends Serializable> commonJoinTask) {
            this.commonJoinTask = commonJoinTask;
        }
    }
}

