/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public Label continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    Expression[] nullReferences;
    int[] nullStatus;
    int nullCount;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext parent, ASTNode associatedNode, Label breakLabel, Label continueLabel, Scope associatedScope) {
        super(parent, associatedNode, breakLabel);
        this.continueLabel = continueLabel;
        this.associatedScope = associatedScope;
    }

    public void complainOnDeferredChecks(BlockScope scope, FlowInfo flowInfo) {
        int i = 0;
        while (i < this.assignCount) {
            VariableBinding variable = this.finalVariables[i];
            if (variable != null) {
                boolean complained = false;
                if (variable instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variable)) {
                        complained = true;
                        scope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variable, this.finalAssignments[i]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variable)) {
                    complained = true;
                    scope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variable, this.finalAssignments[i]);
                }
                if (complained) {
                    FlowContext context = this.parent;
                    while (context != null) {
                        context.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                        context = context.parent;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.nullCount) {
            Expression expression = this.nullReferences[i];
            if (expression != null) {
                LocalVariableBinding local = expression.localVariableBinding();
                switch (this.nullStatus[i]) {
                    case 1: {
                        if (!flowInfo.isDefinitelyNull(local)) break;
                        this.nullReferences[i] = null;
                        this.parent.recordUsingNullReference(scope, local, expression, this.nullStatus[i], flowInfo);
                        break;
                    }
                    case -1: {
                        if (!flowInfo.isDefinitelyNonNull(local)) break;
                        this.nullReferences[i] = null;
                        this.parent.recordUsingNullReference(scope, local, expression, this.nullStatus[i], flowInfo);
                    }
                }
            }
            ++i;
        }
    }

    public Label continueLabel() {
        return this.continueLabel;
    }

    public String individualToString() {
        StringBuffer buffer = new StringBuffer("Looping flow context");
        buffer.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        buffer.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        buffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        buffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return buffer.toString();
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    public void recordContinueFrom(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.initsOnContinue = this.initsOnContinue == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnContinue.mergedWith(flowInfo.copy().unconditionalInits());
    }

    protected boolean recordFinalAssignment(VariableBinding binding, Reference finalAssignment) {
        if (binding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)binding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = finalAssignment;
        this.finalVariables[this.assignCount++] = binding;
        return true;
    }

    protected boolean recordNullReference(Expression expression, int status) {
        if (this.nullCount == 0) {
            this.nullReferences = new Expression[5];
            this.nullStatus = new int[5];
        } else if (this.nullCount == this.nullReferences.length) {
            this.nullReferences = new Expression[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullStatus = new int[this.nullCount * 2];
            System.arraycopy(this.nullStatus, 0, this.nullStatus, 0, this.nullCount);
        }
        this.nullReferences[this.nullCount] = expression;
        this.nullStatus[this.nullCount++] = status;
        return true;
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int i = 0;
        while (i < this.assignCount) {
            if (this.finalAssignments[i] == reference) {
                this.finalAssignments[i] = null;
                this.finalVariables[i] = null;
                return;
            }
            ++i;
        }
    }
}

