/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.charts.datasets.ChartDatasetPanel;
import com.jaspersoft.ireport.designer.charts.datasets.DatasetListsCellRenderer;
import com.jaspersoft.ireport.designer.charts.datasets.TimeSeriesDialog;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;

public class TimeSeriesDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private JRDesignTimeSeriesDataset timeSeriesDataset = null;
    private boolean init = false;
    private ExpressionContext expressionContext = null;
    private JButton jButtonAdd;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JComboBox jComboBoxPeriod;
    private JLabel jLabel1;
    private JLabel jLabelPeriod;
    private JList jList1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelPeriod;
    private JPopupMenu jPopupMenuSeries;
    private JScrollPane jScrollPane1;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_TIME_SERIES_LIST = 1;
    public Object[] newInfo = null;

    public TimeSeriesDatasetPanel() {
        this.initComponents();
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.YEAR, I18n.getString("Global.ComboBox.Year")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.QUARTER, I18n.getString("Global.ComboBox.Quarter")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.MONTH, I18n.getString("Global.ComboBox.Month")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.WEEK, I18n.getString("Global.ComboBox.Week")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.DAY, I18n.getString("Global.ComboBox.Day")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.HOUR, I18n.getString("Global.ComboBox.Hour")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.MINUTE, I18n.getString("Global.ComboBox.Minute")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.SECOND, I18n.getString("Global.ComboBox.Second")));
        this.jComboBoxPeriod.addItem(new Tag(TimePeriodEnum.MILLISECOND, I18n.getString("Global.ComboBox.Milisecond")));
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new DatasetListsCellRenderer());
    }

    public void setTimeSeriesDataset(JRDesignTimeSeriesDataset timeSeriesDataset) {
        this.init = true;
        this.timeSeriesDataset = timeSeriesDataset;
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setEnabled(false);
        DefaultListModel lm = (DefaultListModel)this.jList1.getModel();
        lm.removeAllElements();
        List series = timeSeriesDataset.getSeriesList();
        for (int i = 0; i < series.size(); ++i) {
            lm.addElement(series.get(i));
        }
        if (timeSeriesDataset.getTimePeriod() == null) {
            timeSeriesDataset.setTimePeriod(TimePeriodEnum.DAY.getTimePeriod());
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxPeriod, timeSeriesDataset.getTimePeriod());
        this.init = false;
    }

    public JRDesignTimeSeriesDataset getTimeSeriesDataset() {
        return this.timeSeriesDataset;
    }

    private void initComponents() {
        this.jPopupMenuSeries = new JPopupMenu();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jPanelPeriod = new JPanel();
        this.jLabelPeriod = new JLabel();
        this.jComboBoxPeriod = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jMenuItemCopy.setText(I18n.getString("TimeseriesDatasetPanel.Menu.Copy_series"));
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText(I18n.getString("TimeseriesDatasetPanel.Menu.Paste_series"));
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemPaste);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                TimeSeriesDatasetPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jPanelPeriod.setLayout(new GridBagLayout());
        this.jLabelPeriod.setText(I18n.getString("TimeseriesDatasetPanel.Label.Time_period"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelPeriod.add((Component)this.jLabelPeriod, gridBagConstraints);
        this.jComboBoxPeriod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jComboBoxPeriodActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelPeriod.add((Component)this.jComboBoxPeriod, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelPeriod, gridBagConstraints);
        this.jLabel1.setText(I18n.getString("TimeseriesDatasetPanel.Label.Time_series"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TimeSeriesDatasetPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TimeSeriesDatasetPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(100, 0));
        this.jPanel1.setPreferredSize(new Dimension(100, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAdd.setText(I18n.getString("Global.Button.Add"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText(I18n.getString("Global.Button.Modify"));
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText(I18n.getString("Global.Button.Remove"));
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeSeriesDatasetPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.openExtraWindows();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jMenuItemCopy.setEnabled(this.jList1.getSelectedIndex() >= 0);
                this.jMenuItemPaste.setEnabled(IReportManager.getInstance().getChartSeriesClipBoard() != null && IReportManager.getInstance().getChartSeriesClipBoard().size() > 0);
                this.jPopupMenuSeries.show(this.jList1, evt.getPoint().x, evt.getPoint().y);
                return;
            }
        }
        if (evt.getClickCount() != 2) return;
        if (evt.getButton() != 1) return;
        this.jButtonModifyActionPerformed(null);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        List series = IReportManager.getInstance().getChartSeriesClipBoard();
        if (series != null && series.size() > 0) {
            for (int i = 0; i < series.size(); ++i) {
                if (!(series.get(i) instanceof JRDesignTimeSeries)) continue;
                JRDesignTimeSeries cs = (JRDesignTimeSeries)series.get(i);
                try {
                    cs = (JRDesignTimeSeries)cs.clone();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                this.timeSeriesDataset.addTimeSeries((JRTimeSeries)cs);
                ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            }
            this.jList1.updateUI();
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        Object[] values = this.jList1.getSelectedValues();
        ArrayList<Object> copy_c = new ArrayList<Object>();
        try {
            for (int i = 0; i < values.length; ++i) {
                copy_c.add(((JRDesignTimeSeries)values[i]).clone());
            }
            IReportManager.getInstance().setChartSeriesClipBoard(copy_c);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void jComboBoxPeriodActionPerformed(ActionEvent evt) {
        if (this.init || this.timeSeriesDataset == null) {
            return;
        }
        this.timeSeriesDataset.setTimePeriod((Class)((Tag)this.jComboBoxPeriod.getSelectedItem()).getValue());
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            JRDesignTimeSeries cs = (JRDesignTimeSeries)this.jList1.getSelectedValue();
            TimeSeriesDialog csd = new TimeSeriesDialog(Misc.getMainFrame(), true);
            csd.setExpressionContext(this.getExpressionContext());
            csd.setSeriesExpression((JRDesignExpression)cs.getSeriesExpression());
            csd.setTimePeriodExpression((JRDesignExpression)cs.getTimePeriodExpression());
            csd.setValueExpression((JRDesignExpression)cs.getValueExpression());
            csd.setLabelExpression((JRDesignExpression)cs.getLabelExpression());
            JRDesignHyperlink link = new JRDesignHyperlink();
            ModelUtils.copyHyperlink(cs.getItemHyperlink(), (JRHyperlink)link);
            csd.setSectionItemHyperlink(link);
            if (this.newInfo != null) {
                csd.setFocusedExpression(this.newInfo);
            }
            csd.setVisible(true);
            if (csd.getDialogResult() == 0) {
                cs.setSeriesExpression((JRExpression)csd.getSeriesExpression());
                cs.setTimePeriodExpression((JRExpression)csd.getTimePeriodExpression());
                cs.setValueExpression((JRExpression)csd.getValueExpression());
                cs.setLabelExpression((JRExpression)csd.getLabelExpression());
                cs.setItemHyperlink(csd.getSectionItemHyperlink());
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        TimeSeriesDialog csd = new TimeSeriesDialog(Misc.getMainFrame(), true);
        csd.setExpressionContext(this.getExpressionContext());
        csd.setVisible(true);
        if (csd.getDialogResult() == 0) {
            JRDesignTimeSeries cs = new JRDesignTimeSeries();
            cs.setSeriesExpression((JRExpression)csd.getSeriesExpression());
            cs.setTimePeriodExpression((JRExpression)csd.getTimePeriodExpression());
            cs.setValueExpression((JRExpression)csd.getValueExpression());
            cs.setLabelExpression((JRExpression)csd.getLabelExpression());
            cs.setItemHyperlink(csd.getSectionItemHyperlink());
            this.getTimeSeriesDataset().getSeriesList().add(cs);
            ((DefaultListModel)this.jList1.getModel()).addElement(cs);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        while (this.jList1.getSelectedIndex() >= 0) {
            this.getTimeSeriesDataset().getSeriesList().remove(this.jList1.getSelectedValue());
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(this.jList1.getSelectedIndex());
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonRemove.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonRemove.setEnabled(false);
        }
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.expressionContext = ec;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                int index = (Integer)expressionInfo[1];
                if (index < 0 || this.jList1.getModel().getSize() <= index) break;
                this.jList1.setSelectedIndex(index);
                this.newInfo = new Object[expressionInfo.length - 2];
                for (int i = 2; i < expressionInfo.length; ++i) {
                    this.newInfo[i - 2] = expressionInfo[i];
                }
                break;
            }
        }
    }

    private void openExtraWindows() {
        if (this.newInfo != null) {
            this.jButtonModifyActionPerformed(new ActionEvent(this.jButtonModify, 0, ""));
        }
        this.newInfo = null;
    }

    public void containerWindowOpened() {
        this.openExtraWindows();
    }
}

