/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.openide.util.NbBundle;

public class DataViewUtils {
    public static final int JDBCSQL_TYPE_UNDEFINED = -65535;
    private static Map<String, String> JDBC_SQL_MAP = new HashMap<String, String>();

    public static String getStdSqlType(int n) throws IllegalArgumentException {
        String string = JDBC_SQL_MAP.get(String.valueOf(n));
        if (string instanceof String) {
            return string;
        }
        return "OTHER";
    }

    public static boolean isNumeric(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrecisionRequired(int n, boolean bl) {
        if (bl && n == 2004 || n == 2005) {
            return true;
        }
        return DataViewUtils.isPrecisionRequired(n);
    }

    public static boolean isPrecisionRequired(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 70: 
            case 91: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
        }
        return true;
    }

    public static boolean isScaleRequired(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isString(int n) {
        switch (n) {
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNullString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void closeResources(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResources(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeResources(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getColumnToolTip(DBColumn dBColumn) {
        boolean bl = dBColumn.isPrimaryKey();
        boolean bl2 = dBColumn.isForeignKey();
        boolean bl3 = dBColumn.isNullable();
        boolean bl4 = dBColumn.isGenerated();
        StringBuilder stringBuilder = new StringBuilder("<html> <table border=0 cellspacing=0 cellpadding=0 >");
        stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_name")).append("</td> <td> &nbsp; : &nbsp; <b>");
        stringBuilder.append(dBColumn.getName()).append("</b> </td> </tr>");
        stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_type")).append("</td> <td> &nbsp; : &nbsp; <b>");
        stringBuilder.append(DataViewUtils.getStdSqlType(dBColumn.getJdbcType()).toUpperCase()).append("</b> </td> </tr>");
        switch (dBColumn.getJdbcType()) {
            case 1: 
            case 12: {
                stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_length")).append("</td> <td> &nbsp; : &nbsp; <b>");
                break;
            }
            default: {
                stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_precision")).append("</td> <td> &nbsp; : &nbsp; <b>");
            }
        }
        stringBuilder.append(dBColumn.getPrecision()).append("</b> </td> </tr>");
        switch (dBColumn.getJdbcType()) {
            case -6: 
            case -3: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            default: {
                stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_scale")).append("</td> <td> &nbsp; : &nbsp; <b>");
                stringBuilder.append(dBColumn.getScale()).append("</b> </td> </tr>");
            }
        }
        if (bl) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_PK")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        if (bl2) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_FK")).append("</td> <td> &nbsp; : &nbsp; <b>" + DataViewUtils.getForeignKeyString(dBColumn)).append("</b>").append("</td> </tr>");
        }
        if (!bl3) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_nullable")).append("</td> <td> &nbsp; : &nbsp; <b> No </b> </td> </tr>");
        }
        if (bl4) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_generated")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        stringBuilder.append("</table> </html>");
        return stringBuilder.toString();
    }

    public static String getForeignKeyString(DBColumn dBColumn) {
        String string = dBColumn.getName() + " --> ";
        StringBuilder stringBuilder = new StringBuilder(string);
        DBTable dBTable = (DBTable)dBColumn.getParentObject();
        List<DBForeignKey> list = dBTable.getForeignKeys();
        for (DBForeignKey dBForeignKey : list) {
            if (!dBForeignKey.contains(dBColumn)) continue;
            List<String> list2 = dBForeignKey.getPKColumnNames();
            Iterator<String> iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                stringBuilder.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    private DataViewUtils() {
    }

    static {
        JDBC_SQL_MAP.put(String.valueOf(2003), "array");
        JDBC_SQL_MAP.put(String.valueOf(2002), "struct");
        JDBC_SQL_MAP.put(String.valueOf(-5), "bigint");
        JDBC_SQL_MAP.put(String.valueOf(-2), "binary");
        JDBC_SQL_MAP.put(String.valueOf(-7), "bit");
        JDBC_SQL_MAP.put(String.valueOf(2004), "blob");
        JDBC_SQL_MAP.put(String.valueOf(16), "boolean");
        JDBC_SQL_MAP.put(String.valueOf(1), "char");
        JDBC_SQL_MAP.put(String.valueOf(2005), "clob");
        JDBC_SQL_MAP.put(String.valueOf(91), "date");
        JDBC_SQL_MAP.put(String.valueOf(3), "decimal");
        JDBC_SQL_MAP.put(String.valueOf(2001), "distinct");
        JDBC_SQL_MAP.put(String.valueOf(8), "double");
        JDBC_SQL_MAP.put(String.valueOf(6), "float");
        JDBC_SQL_MAP.put(String.valueOf(4), "integer");
        JDBC_SQL_MAP.put(String.valueOf(-4), "longvarbinary");
        JDBC_SQL_MAP.put(String.valueOf(-1), "longvarchar");
        JDBC_SQL_MAP.put(String.valueOf(2), "numeric");
        JDBC_SQL_MAP.put(String.valueOf(7), "real");
        JDBC_SQL_MAP.put(String.valueOf(5), "smallint");
        JDBC_SQL_MAP.put(String.valueOf(92), "time");
        JDBC_SQL_MAP.put(String.valueOf(93), "timestamp");
        JDBC_SQL_MAP.put(String.valueOf(-6), "tinyint");
        JDBC_SQL_MAP.put(String.valueOf(-3), "varbinary");
        JDBC_SQL_MAP.put(String.valueOf(12), "varchar");
        JDBC_SQL_MAP.put(String.valueOf(2000), "java_object");
        JDBC_SQL_MAP.put(String.valueOf(1111), "other");
        JDBC_SQL_MAP.put(String.valueOf(2006), "ref");
        JDBC_SQL_MAP.put(String.valueOf(70), "datalink");
        JDBC_SQL_MAP.put(String.valueOf(-9), "nvarchar");
        JDBC_SQL_MAP.put(String.valueOf(-8), "rowid");
        JDBC_SQL_MAP.put(String.valueOf(-15), "nchar");
        JDBC_SQL_MAP.put(String.valueOf(0), "null");
    }
}

