/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.PhysicalView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class ProjectsRootNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(ProjectsRootNode.class.getName());
    static final int PHYSICAL_VIEW = 0;
    static final int LOGICAL_VIEW = 1;
    private static final String ICON_BASE = "org/netbeans/modules/project/ui/resources/projectsRootNode.gif";
    private static final String ACTIONS_FOLDER = "ProjectsTabActions";
    private ResourceBundle bundle;
    private final int type;

    public ProjectsRootNode(int n) {
        super((Children)new ProjectChildren(n));
        this.setIconBaseWithExtension(ICON_BASE);
        this.type = n;
    }

    public String getName() {
        return "OpenProjects";
    }

    public String getDisplayName() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ProjectsRootNode.class);
        }
        return this.bundle.getString("LBL_OpenProjectsNode_Name");
    }

    public boolean canRename() {
        return false;
    }

    public Node.Handle getHandle() {
        return new Handle(this.type);
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.type == 0) {
            return new Action[0];
        }
        List list = Utilities.actionsForPath((String)ACTIONS_FOLDER);
        return list.toArray(new Action[list.size()]);
    }

    Node findNode(FileObject fileObject) {
        ProjectChildren projectChildren = (ProjectChildren)this.getChildren();
        if (projectChildren.type == 1) {
            int n;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            int n2 = n = project != null ? 0 : 1;
            while (n < 2) {
                for (Node node : projectChildren.getNodes(true)) {
                    Node node2;
                    LogicalViewProvider logicalViewProvider;
                    Project project2 = (Project)node.getLookup().lookup(Project.class);
                    assert (project2 != null) : "Should have had a Project in lookup of " + node;
                    if (n == 0 && project2 != project || (logicalViewProvider = (LogicalViewProvider)project2.getLookup().lookup(LogicalViewProvider.class)) == null || (node2 = logicalViewProvider.findPath(node, (Object)fileObject)) == null) continue;
                    return node2;
                }
                ++n;
            }
            return null;
        }
        if (projectChildren.type == 0) {
            for (Node node : projectChildren.getNodes(true)) {
                Node node3;
                PhysicalView.PathFinder pathFinder = (PhysicalView.PathFinder)node.getLookup().lookup(PhysicalView.PathFinder.class);
                if (pathFinder == null || (node3 = pathFinder.findPath(node, fileObject)) == null) continue;
                return node3;
            }
            return null;
        }
        return null;
    }

    static SearchInfo alwaysSearchableSearchInfo(Project project) {
        return new AlwaysSearchableSearchInfo(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(Project project) {
            SearchInfo searchInfo = (SearchInfo)project.getLookup().lookup(SearchInfo.class);
            if (searchInfo != null) {
                this.delegate = searchInfo;
            } else {
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
                FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
                }
                this.delegate = SearchInfoFactory.createSearchInfo((FileObject[])fileObjectArray, (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
            }
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    private static final class BadgingLookup
    extends ProxyLookup {
        public BadgingLookup(Lookup ... lookupArray) {
            super(lookupArray);
        }

        public void setMyLookups(Lookup ... lookupArray) {
            this.setLookups(lookupArray);
        }

        public boolean isSearchInfo() {
            return this.getLookups().length > 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BadgingNode
    extends FilterNode
    implements ChangeListener,
    PropertyChangeListener,
    Runnable,
    FileStatusListener {
        private static String badgedNamePattern = NbBundle.getMessage(ProjectsRootNode.class, (String)"LBL_MainProject_BadgedNamePattern");
        private final Object privateLock = new Object();
        private Set<FileObject> files;
        private Map<FileSystem, FileStatusListener> fileSystemListeners;
        private ChangeListener sourcesListener;
        private Map<SourceGroup, PropertyChangeListener> groupsListeners;
        RequestProcessor.Task task;
        private boolean nameChange;
        private boolean iconChange;
        private final boolean logicalView;
        private final ProjectChildren.Pair pair;
        private final Set<FileObject> projectDirsListenedTo = new WeakSet();
        private final FileChangeListener newSubDirListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fileEvent) {
                BadgingNode.this.setProjectFiles();
            }

            public void fileFolderCreated(FileEvent fileEvent) {
                BadgingNode.this.setProjectFiles();
            }
        };

        public BadgingNode(ProjectChildren.Pair pair, Node node, boolean bl, boolean bl2) {
            super(node, null, BadgingNode.badgingLookup(node, bl));
            this.pair = pair;
            this.logicalView = bl2;
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
            this.setProjectFiles();
        }

        private static Lookup badgingLookup(Node node, boolean bl) {
            if (bl) {
                return new BadgingLookup(node.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo((Project)node.getLookup().lookup(Project.class))));
            }
            return new BadgingLookup(node.getLookup());
        }

        protected final void setProjectFiles() {
            Project project = (Project)this.getLookup().lookup(Project.class);
            if (project != null && !(project instanceof LazyProject)) {
                this.setProjectFiles(project);
            }
        }

        private final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")), project.getProjectDirectory());
        }

        private final void setGroups(Collection<SourceGroup> collection, FileObject fileObject) {
            if (this.groupsListeners != null) {
                for (Map.Entry object2 : this.groupsListeners.entrySet()) {
                    ((SourceGroup)object2.getKey()).removePropertyChangeListener((PropertyChangeListener)object2.getValue());
                }
            }
            HashMap hashMap = new HashMap();
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (SourceGroup sourceGroup : collection) {
                PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup);
                hashMap.put(sourceGroup, propertyChangeListener);
                sourceGroup.addPropertyChangeListener(propertyChangeListener);
                FileObject fileObject2 = sourceGroup.getRootFolder();
                if (fileObject2.equals(fileObject)) {
                    for (FileObject fileObject3 : fileObject2.getChildren()) {
                        Project project = FileOwnerQuery.getOwner((FileObject)fileObject3);
                        if (project == null || project.getProjectDirectory() != fileObject) continue;
                        hashSet.add(fileObject3);
                    }
                    if (!this.projectDirsListenedTo.add(fileObject2)) continue;
                    fileObject2.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.newSubDirListener, (Object)fileObject2));
                    continue;
                }
                hashSet.add(fileObject2);
            }
            this.groupsListeners = hashMap;
            this.setFiles(hashSet);
        }

        protected final void setFiles(Set<FileObject> set) {
            if (this.fileSystemListeners != null) {
                for (Map.Entry<FileSystem, FileStatusListener> object : this.fileSystemListeners.entrySet()) {
                    object.getKey().removeFileStatusListener(object.getValue());
                }
            }
            this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
            this.files = set;
            HashSet hashSet = new HashSet();
            for (FileObject fileObject : set) {
                try {
                    FileSystem fileStateInvalidException = fileObject.getFileSystem();
                    if (hashSet.contains(fileStateInvalidException)) continue;
                    hashSet.add(fileStateInvalidException);
                    FileStatusListener fileStatusListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                    fileStateInvalidException.addFileStatusListener(fileStatusListener);
                    this.fileSystemListeners.put(fileStateInvalidException, fileStatusListener);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.INFO, "Cannot get " + fileObject + " filesystem, ignoring...", fileStateInvalidException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public String getDisplayName() {
            String string = super.getDisplayName();
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    string = this.files.iterator().next().getFileSystem().getStatus().annotateName(string, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return this.isMain() ? MessageFormat.format(badgedNamePattern, string) : string;
        }

        public String getHtmlDisplayName() {
            String string = this.getOriginal().getHtmlDisplayName();
            String string2 = null;
            if (this.isMain() && string == null) {
                string2 = super.getDisplayName();
                try {
                    string2 = XMLUtil.toElementContent((String)string2);
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileSystem.HtmlStatus htmlStatus;
                    String string3;
                    FileSystem.Status status = this.files.iterator().next().getFileSystem().getStatus();
                    if (status instanceof FileSystem.HtmlStatus && (string3 = (htmlStatus = (FileSystem.HtmlStatus)status).annotateNameHtml(super.getDisplayName(), this.files)) != null && !super.getDisplayName().equals(string3)) {
                        return this.isMain() ? "<b>" + string3 + "</b>" : string3;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return this.isMain() ? "<b>" + (string == null ? string2 : string) + "</b>" : string;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    LOG.log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireDisplayNameChange(null, null);
            }
            if ("ReplaceProject".equals(propertyChangeEvent.getPropertyName())) {
                OpenProjectList.LOGGER.log(Level.FINER, "replacing for {0}", this);
                Project project = (Project)this.getLookup().lookup(Project.class);
                if (project == null) {
                    OpenProjectList.LOGGER.log(Level.FINE, "no project in lookup {0}", this);
                    return;
                }
                FileObject fileObject = project.getProjectDirectory();
                Project project2 = (Project)propertyChangeEvent.getNewValue();
                assert (project2 != null);
                if (project2.getProjectDirectory().equals(fileObject)) {
                    Node node = this.getParentNode();
                    if (node != null) {
                        Object object;
                        ProjectChildren projectChildren = (ProjectChildren)node.getChildren();
                        Node node2 = null;
                        if (this.logicalView) {
                            node2 = projectChildren.logicalViewForProject(project2, null);
                            OpenProjectList.LOGGER.log(Level.FINER, "logical view {0}", node2);
                        } else {
                            object = PhysicalView.createNodesForProject(project2);
                            OpenProjectList.LOGGER.log(Level.FINER, "physical view {0}", Arrays.asList(object));
                            if (((Node[])object).length > 1) {
                                this.pair.project = project2;
                                OpenProjectList.LOGGER.log(Level.FINER, "refreshing for {0}", project2);
                                projectChildren.refresh(project2);
                                OpenProjectList.LOGGER.log(Level.FINER, "refreshed for {0}", project2);
                                return;
                            }
                            for (Node node3 : object) {
                                if (!PhysicalView.isProjectDirNode(node3)) continue;
                                node2 = node3;
                                break;
                            }
                            assert (node2 != null) : "newProject yields null node: " + project2;
                        }
                        OpenProjectList.LOGGER.log(Level.FINER, "change original: {0}", node2);
                        OpenProjectList.LOGGER.log(Level.FINER, "children before change original: {0}", this.getChildren());
                        OpenProjectList.LOGGER.log(Level.FINER, "delegate children before change original: {0}", this.getOriginal().getChildren());
                        this.changeOriginal(node2, true);
                        OpenProjectList.LOGGER.log(Level.FINER, "delegate after change original: {0}", this.getOriginal());
                        OpenProjectList.LOGGER.log(Level.FINER, "name after change original: {0}", this.getName());
                        OpenProjectList.LOGGER.log(Level.FINER, "children after change original: {0}", this.getChildren());
                        OpenProjectList.LOGGER.log(Level.FINER, "delegate children after change original: {0}", this.getOriginal().getChildren());
                        object = (BadgingLookup)this.getLookup();
                        if (((BadgingLookup)((Object)object)).isSearchInfo()) {
                            OpenProjectList.LOGGER.log(Level.FINER, "is search info {0}", object);
                            ((BadgingLookup)((Object)object)).setMyLookups(node2.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo(project2)));
                        } else {
                            OpenProjectList.LOGGER.log(Level.FINER, "no search info {0}", object);
                            ((BadgingLookup)((Object)object)).setMyLookups(node2.getLookup());
                        }
                        OpenProjectList.LOGGER.log(Level.FINER, "done {0}", this);
                    }
                    this.setProjectFiles();
                } else {
                    OpenProjectList.LOGGER.log(Level.FINE, "wrong directories. current: " + fileObject + " new " + project2.getProjectDirectory());
                }
            }
            if ("containership".equals(propertyChangeEvent.getPropertyName())) {
                this.setProjectFiles();
            }
        }

        private boolean isMain() {
            Project project = (Project)this.getLookup().lookup(Project.class);
            return project != null && OpenProjectList.getDefault().isMainProject(project);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BadgingNode.this.setProjectFiles();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectChildren
    extends Children.Keys<Pair>
    implements ChangeListener,
    PropertyChangeListener {
        private Map<Sources, Reference<Project>> sources2projects = new WeakHashMap<Sources, Reference<Project>>();
        int type;

        public ProjectChildren(int n) {
            this.type = n;
        }

        public void addNotify() {
            OpenProjectList.getDefault().addPropertyChangeListener(this);
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            OpenProjectList.getDefault().removePropertyChangeListener(this);
            for (Sources sources : this.sources2projects.keySet()) {
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(Pair pair) {
            Node[] nodeArray;
            Project project = pair.project;
            Node[] nodeArray2 = null;
            boolean[] blArray = new boolean[]{true};
            if (this.type == 0) {
                nodeArray = ProjectUtils.getSources((Project)project);
                nodeArray.removeChangeListener((ChangeListener)this);
                nodeArray.addChangeListener((ChangeListener)this);
                this.sources2projects.put((Sources)nodeArray, new WeakReference<Project>(project));
                nodeArray2 = PhysicalView.createNodesForProject(project);
            } else {
                nodeArray2 = new Node[]{this.logicalViewForProject(project, blArray)};
            }
            nodeArray = new Node[nodeArray2.length];
            for (int i = 0; i < nodeArray2.length; ++i) {
                nodeArray[i] = this.type == 0 && !PhysicalView.isProjectDirNode(nodeArray2[i]) ? nodeArray2[i] : new BadgingNode(pair, nodeArray2[i], this.type == 1 && blArray[0], this.type == 1);
            }
            return nodeArray;
        }

        final Node logicalViewForProject(Project project, boolean[] blArray) {
            Node node;
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider == null) {
                LOG.warning("Warning - project of " + project.getClass() + " in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " failed to supply a LogicalViewProvider in its lookup");
                Sources sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                Node[] nodeArray = PhysicalView.createNodesForProject(project);
                node = nodeArray.length > 0 ? nodeArray[0] : Node.EMPTY;
            } else {
                node = logicalViewProvider.createLogicalView();
                if (node.getLookup().lookup(Project.class) != project) {
                    LOG.warning("Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                    if (blArray != null) {
                        blArray[0] = false;
                    }
                }
            }
            return node;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("OpenProjects".equals(propertyChangeEvent.getPropertyName())) {
                this.setKeys(this.getKeys());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Reference<Project> reference = this.sources2projects.get(changeEvent.getSource());
            if (reference == null) {
                return;
            }
            final Project project = reference.get();
            if (project == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectChildren.this.refresh(project);
                }
            });
        }

        final void refresh(Project project) {
            this.refreshKey(new Pair(project));
        }

        public Collection<Pair> getKeys() {
            List<Project> list = Arrays.asList(OpenProjectList.getDefault().getOpenProjects());
            Collections.sort(list, OpenProjectList.PROJECT_BY_DISPLAYNAME);
            List<Pair> list2 = Arrays.asList(new Pair[list.size()]);
            for (int i = 0; i < list.size(); ++i) {
                Project project = list.get(i);
                list2.set(i, new Pair(project));
            }
            return list2;
        }

        static final class Pair {
            public Project project;
            public final FileObject fo;

            public Pair(Project project) {
                this.project = project;
                this.fo = project.getProjectDirectory();
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Pair pair = (Pair)object;
                return this.fo == pair.fo || this.fo != null && this.fo.equals(pair.fo);
            }

            public int hashCode() {
                int n = 7;
                n = 53 * n + (this.fo != null ? this.fo.hashCode() : 0);
                return n;
            }
        }
    }

    private static class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;
        private int viewType;

        public Handle(int n) {
            this.viewType = n;
        }

        public Node getNode() {
            return new ProjectsRootNode(this.viewType);
        }
    }
}

