/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(JRAbstractLRUVirtualizer.class);
    protected static final int CLASSLOADER_IDX_NOT_SET = -1;
    protected final Map<ClassLoader, Integer> classLoadersIndexes = new HashMap<ClassLoader, Integer>();
    protected final List<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();
    private final Cache pagedIn;
    private final ReferenceMap pagedOut;
    protected JRVirtualizable lastObject;
    protected ReferenceMap lastObjectMap;
    protected ReferenceMap lastObjectSet;
    private boolean readOnly;

    protected static boolean isAncestorClassLoader(ClassLoader loader) {
        for (ClassLoader ancestor = JRAbstractLRUVirtualizer.class.getClassLoader(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(loader)) continue;
            return true;
        }
        return false;
    }

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this.pagedIn = new Cache(maxSize);
        this.pagedOut = new ReferenceMap(0, 2);
        this.lastObject = null;
        this.lastObjectMap = new ReferenceMap(2, 2);
        this.lastObjectSet = new ReferenceMap(2, 0);
    }

    protected final synchronized boolean isPagedOut(String id) {
        return this.pagedOut.containsKey((Object)id);
    }

    protected synchronized boolean isPagedOutAndTouch(JRVirtualizable o, String uid) {
        boolean virtualized = this.isPagedOut(uid);
        if (!virtualized) {
            this.touch(o);
        }
        return virtualized;
    }

    protected final void setLastObject(JRVirtualizable o) {
        if (this.lastObject != o) {
            JRVirtualizationContext context;
            Object ownerLast;
            if (o != null && (ownerLast = this.lastObjectMap.get((Object)(context = o.getContext()))) != o) {
                if (ownerLast != null) {
                    this.lastObjectSet.remove(ownerLast);
                }
                this.lastObjectMap.put((Object)context, (Object)o);
                this.lastObjectSet.put((Object)o, (Object)Boolean.TRUE);
            }
            this.lastObject = o;
        }
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final boolean isReadOnly(JRVirtualizable o) {
        return this.readOnly || o.getContext().isReadOnly();
    }

    public synchronized void registerObject(JRVirtualizable o) {
        this.setLastObject(o);
        JRVirtualizable old = this.pagedIn.put(o.getUID(), o);
        if (old != null && old != o) {
            this.pagedIn.put(o.getUID(), old);
            throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registered object " + o + " with id " + o.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObject(JRVirtualizable o) {
        String uid = o.getUID();
        try {
            this.dispose(o.getUID());
        }
        catch (Exception e) {
            log.error((Object)"Error removing virtual data", (Throwable)e);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable oldIn = this.pagedIn.remove(uid);
            if (oldIn != null) {
                if (oldIn != o) {
                    this.pagedIn.put(uid, oldIn);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
                }
            } else {
                Object oldOut = this.pagedOut.remove((Object)uid);
                if (oldOut != null && oldOut != o) {
                    this.pagedOut.put((Object)uid, oldOut);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("deregistered object " + o + " with id " + o.getUID()));
        }
    }

    public synchronized void touch(JRVirtualizable o) {
        if (this.lastObject != o) {
            this.setLastObject(this.pagedIn.get(o.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.isPagedOutAndTouch(o, uid)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("internalizing " + uid));
            }
            try {
                this.pageIn(o);
            }
            catch (IOException e) {
                log.error((Object)"Error devirtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.setLastObject(o);
                this.pagedOut.remove((Object)uid);
                this.pagedIn.put(uid, o);
            }
            o.afterInternalization();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.isPagedOutAndTouch(o, uid)) {
            this.dispose(uid);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove((Object)uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualizeData(JRVirtualizable o) {
        String uid = o.getUID();
        if (!this.isPagedOut(uid)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("externalizing " + uid));
            }
            o.beforeExternalization();
            try {
                this.pageOut(o);
            }
            catch (IOException e) {
                log.error((Object)"Error virtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            o.afterExternalization();
            o.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put((Object)uid, (Object)o);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o, OutputStream out) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectOutputStream oos = new ClassLoaderAnnotationObjectOutputStream(out);
            oos.writeObject(o.getVirtualData());
            oos.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error virtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected final void readData(JRVirtualizable o, InputStream in) throws JRRuntimeException {
        try {
            ClassLoaderAnnotationObjectInputStream ois = new ClassLoaderAnnotationObjectInputStream(in);
            o.setVirtualData(ois.readObject());
        }
        catch (IOException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected synchronized void reset() {
        this.readOnly = false;
    }

    protected final void disposeAll() {
        String id;
        Iterator<Object> it = this.pagedOut.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
        it = this.pagedIn.idIterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected abstract void dispose(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoaderAnnotationObjectInputStream
    extends ObjectInputStream {
        public ClassLoaderAnnotationObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            try {
                clazz = super.resolveClass(desc);
                this.readShort();
            }
            catch (ClassNotFoundException e) {
                short loaderIdx = this.readShort();
                if (loaderIdx == -1) {
                    throw e;
                }
                ClassLoader loader = JRAbstractLRUVirtualizer.this.classLoadersList.get(loaderIdx);
                clazz = Class.forName(desc.getName(), false, loader);
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoaderAnnotationObjectOutputStream
    extends ObjectOutputStream {
        public ClassLoaderAnnotationObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> clazz) throws IOException {
            int loaderIdx;
            super.annotateClass(clazz);
            ClassLoader classLoader = clazz.getClassLoader();
            if (clazz.isPrimitive() || classLoader == null || JRAbstractLRUVirtualizer.isAncestorClassLoader(classLoader)) {
                loaderIdx = -1;
            } else {
                Integer idx = JRAbstractLRUVirtualizer.this.classLoadersIndexes.get(classLoader);
                if (idx == null) {
                    idx = JRAbstractLRUVirtualizer.this.classLoadersList.size();
                    JRAbstractLRUVirtualizer.this.classLoadersIndexes.put(classLoader, idx);
                    JRAbstractLRUVirtualizer.this.classLoadersList.add(classLoader);
                }
                loaderIdx = idx;
            }
            this.writeShort(loaderIdx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Cache {
        private final ReferenceQueue<JRVirtualizable> refQueue;
        private final LRUScanMap map;

        Cache(int maxSize) {
            this.map = new LRUScanMap(maxSize);
            this.refQueue = new ReferenceQueue();
        }

        protected JRVirtualizable getMapValue(Object val) {
            Reference ref;
            JRVirtualizable o = val == null ? null : ((ref = (Reference)val).isEnqueued() ? null : (JRVirtualizable)ref.get());
            return o;
        }

        protected Object toMapValue(JRVirtualizable val) {
            return val == null ? null : new CacheReference(val, this.refQueue);
        }

        protected void purge() {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(ref.getId());
            }
        }

        public JRVirtualizable get(String id) {
            this.purge();
            return this.getMapValue(this.map.get(id));
        }

        public JRVirtualizable put(String id, JRVirtualizable o) {
            this.purge();
            return this.getMapValue(this.map.put(id, this.toMapValue(o)));
        }

        public JRVirtualizable remove(String id) {
            this.purge();
            return this.getMapValue(this.map.remove(id));
        }

        public Iterator<String> idIterator() {
            this.purge();
            final Iterator valsIt = this.map.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return valsIt.hasNext();
                }

                @Override
                public String next() {
                    CacheReference ref = (CacheReference)valsIt.next();
                    return ref.getId();
                }

                @Override
                public void remove() {
                    valsIt.remove();
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class LRUScanMap
        extends LRUMap {
            private static final long serialVersionUID = 10200L;

            public LRUScanMap(int maxSize) {
                super(maxSize);
            }

            protected void removeLRU() {
                Map.Entry entry = this.getFirst();
                boolean found = this.isRemovable(entry);
                if (!found) {
                    Iterator entriesIt = this.entrySet().iterator();
                    entriesIt.next();
                    while (!found && entriesIt.hasNext()) {
                        entry = (Map.Entry)entriesIt.next();
                        found = this.isRemovable(entry);
                    }
                }
                if (!found) {
                    log.warn((Object)("The virtualizer is used by more contexts than its in-memory cache size " + this.getMaximumSize()));
                    return;
                }
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.remove(key);
                this.processRemovedLRU(key, value);
            }

            protected boolean isRemovable(Map.Entry<?, ?> entry) {
                JRVirtualizable value = Cache.this.getMapValue(entry.getValue());
                return value == null || !JRAbstractLRUVirtualizer.this.lastObjectSet.containsKey((Object)value);
            }

            protected void processRemovedLRU(Object key, Object value) {
                JRVirtualizable o = Cache.this.getMapValue(value);
                if (o != null) {
                    JRAbstractLRUVirtualizer.this.virtualizeData(o);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheReference
    extends WeakReference<JRVirtualizable> {
        private final String id;

        public CacheReference(JRVirtualizable o, ReferenceQueue<JRVirtualizable> queue) {
            super(o, queue);
            this.id = o.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

