/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.util.JRProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXlsAbstractExporterNature
implements ExporterNature {
    public static final String PROPERTY_BREAK_BEFORE_ROW = "net.sf.jasperreports.export.xls.break.before.row";
    public static final String PROPERTY_BREAK_AFTER_ROW = "net.sf.jasperreports.export.xls.break.after.row";
    protected ExporterFilter filter;
    protected boolean isIgnoreGraphics;
    protected boolean isIgnorePageMargins;

    protected JRXlsAbstractExporterNature(ExporterFilter filter, boolean isIgnoreGraphics) {
        this(filter, isIgnoreGraphics, false);
    }

    protected JRXlsAbstractExporterNature(ExporterFilter filter, boolean isIgnoreGraphics, boolean isIgnorePageMargins) {
        this.filter = filter;
        this.isIgnoreGraphics = isIgnoreGraphics;
        this.isIgnorePageMargins = isIgnorePageMargins;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        return !(this.isIgnoreGraphics && !(element instanceof JRPrintText) && !(element instanceof JRPrintFrame) || this.filter != null && !this.filter.isToExport(element));
    }

    @Override
    public boolean isDeep(JRPrintFrame frame) {
        return true;
    }

    @Override
    public boolean isSplitSharedRowSpan() {
        return false;
    }

    @Override
    public boolean isSpanCells() {
        return true;
    }

    @Override
    public boolean isIgnoreLastRow() {
        return false;
    }

    @Override
    public boolean isHorizontallyMergeEmptyCells() {
        return false;
    }

    @Override
    public boolean isIgnorePageMargins() {
        return this.isIgnorePageMargins;
    }

    @Override
    public boolean isBreakBeforeRow(JRPrintElement element) {
        return Boolean.valueOf(element.getPropertiesMap().getProperty(PROPERTY_BREAK_BEFORE_ROW));
    }

    @Override
    public boolean isBreakAfterRow(JRPrintElement element) {
        return Boolean.valueOf(element.getPropertiesMap().getProperty(PROPERTY_BREAK_AFTER_ROW));
    }

    @Override
    public Boolean getRowAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.row")) {
            return JRProperties.getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.row", false);
        }
        return null;
    }

    @Override
    public Boolean getColumnAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.column")) {
            return JRProperties.getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.column", false);
        }
        return null;
    }

    @Override
    public Integer getCustomColumnWidth(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width")) {
            return JRProperties.getIntegerProperty(element, "net.sf.jasperreports.export.xls.column.width", 0);
        }
        return null;
    }

    @Override
    public Float getColumnWidthRatio(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width.ratio")) {
            return Float.valueOf(JRProperties.getFloatProperty(element, "net.sf.jasperreports.export.xls.column.width.ratio", 0.0f));
        }
        return null;
    }

    @Override
    public List<JRProperties.PropertySuffix> getRowLevelSuffixes(JRPrintElement element) {
        if (element.hasProperties()) {
            return JRProperties.getProperties(element, "net.sf.jasperreports.export.xls.row.outline.level.");
        }
        return null;
    }
}

