/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.util.JRProperties;

public class JROriginExporterFilter
implements ResetableExporterFilter {
    public static final String PROPERTY_EXCLUDE_ORIGIN_PREFIX = "exclude.origin.";
    private static final String KEEP_FIRST_PREFIX = "keep.first.";
    private static final String BAND_PREFIX = "band.";
    private static final String GROUP_PREFIX = "group.";
    private static final String REPORT_PREFIX = "report.";
    private Map<JROrigin, Boolean> originsToExclude = new HashMap<JROrigin, Boolean>();
    private Map<Integer, JRPrintElement> firstOccurrences = new HashMap<Integer, JRPrintElement>();

    public void addOrigin(JROrigin origin) {
        this.addOrigin(origin, false);
    }

    public void addOrigin(JROrigin origin, boolean keepFirst) {
        this.originsToExclude.put(origin, keepFirst ? Boolean.TRUE : Boolean.FALSE);
    }

    public void removeOrigin(JROrigin origin) {
        this.originsToExclude.remove(origin);
    }

    public void reset() {
        this.firstOccurrences = new HashMap<Integer, JRPrintElement>();
    }

    public boolean isToExport(JRPrintElement element) {
        JROrigin origin = element.getOrigin();
        Boolean keepFirst = origin == null ? null : this.originsToExclude.get(origin);
        boolean originMatched = keepFirst != null;
        return !originMatched || keepFirst != false && this.isFirst(element);
    }

    private boolean isFirst(JRPrintElement element) {
        int elementId = element.getSourceElementId();
        if (elementId == 0) {
            return true;
        }
        JRPrintElement firstElement = this.firstOccurrences.get(elementId);
        if (firstElement == null || firstElement == element) {
            this.firstOccurrences.put(elementId, element);
            return true;
        }
        return false;
    }

    public static JROriginExporterFilter getFilter(JRPropertiesMap propertiesMap, String originFilterPrefix) {
        JROriginExporterFilter filter = null;
        filter = JROriginExporterFilter.addOriginsToFilter(filter, propertiesMap, originFilterPrefix, false);
        filter = JROriginExporterFilter.addOriginsToFilter(filter, propertiesMap, originFilterPrefix + KEEP_FIRST_PREFIX, true);
        return filter;
    }

    private static JROriginExporterFilter addOriginsToFilter(JROriginExporterFilter filter, JRPropertiesMap propertiesMap, String originFilterPrefix, boolean keepFirst) {
        List<JRProperties.PropertySuffix> properties = JRProperties.getProperties(originFilterPrefix + BAND_PREFIX);
        properties.addAll(JRProperties.getProperties(propertiesMap, originFilterPrefix + BAND_PREFIX));
        if (!properties.isEmpty()) {
            filter = filter == null ? new JROriginExporterFilter() : filter;
            for (JRProperties.PropertySuffix propertySuffix : properties) {
                String suffix = propertySuffix.getSuffix();
                BandTypeEnum bandType = BandTypeEnum.getByName(JRProperties.getProperty(propertiesMap, propertySuffix.getKey()));
                if (bandType == null) continue;
                filter.addOrigin(new JROrigin(JRProperties.getProperty(propertiesMap, originFilterPrefix + REPORT_PREFIX + suffix), JRProperties.getProperty(propertiesMap, originFilterPrefix + GROUP_PREFIX + suffix), bandType), keepFirst);
            }
        }
        return filter;
    }
}

