/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.ElementStore;
import net.sf.jasperreports.engine.base.ElementsBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ElementsBlockList
implements ElementStore,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ElementsBlockList.class);
    private static final int INITIAL_SIZE = 3;
    private static final int MAX_INCREMENT = 200;
    private int blockCount = 1;
    private int[] offsets;
    private ElementsBlock[] blocks = new ElementsBlock[3];
    private int size;
    private transient int lastIndex = -1;

    public ElementsBlockList(ElementsBlock block) {
        this.offsets = new int[3];
        this.blocks[0] = block;
        this.offsets[0] = 0;
        this.size = block.size();
    }

    protected void addBlock() {
        ElementsBlock block;
        this.incrementBlocks();
        this.blocks[this.blockCount] = block = new ElementsBlock(this.blocks[0].getContext());
        this.offsets[this.blockCount] = this.size;
        ++this.blockCount;
        if (log.isDebugEnabled()) {
            log.debug((Object)("created block " + block + " at offset " + this.size));
        }
    }

    protected void incrementBlocks() {
        if (this.blockCount == this.blocks.length) {
            int newSize = Math.min(this.blockCount * 3 / 2 + 1, this.blockCount + 200);
            ElementsBlock[] newBlocks = new ElementsBlock[newSize];
            System.arraycopy(this.blocks, 0, newBlocks, 0, this.blockCount);
            this.blocks = newBlocks;
            int[] newOffsets = new int[newSize];
            System.arraycopy(this.offsets, 0, newOffsets, 0, this.blockCount);
            this.offsets = newOffsets;
        }
    }

    public int size() {
        return this.size;
    }

    public JRPrintElement get(int index) {
        int blockIndex = this.blockIndex(index);
        return this.blocks[blockIndex].get(index - this.offsets[blockIndex]);
    }

    public boolean add(JRPrintElement element) {
        if (!this.blocks[this.blockCount - 1].add(element, false)) {
            this.addBlock();
            this.blocks[this.blockCount - 1].add(element, true);
        }
        ++this.size;
        return true;
    }

    public boolean add(int index, JRPrintElement element) {
        boolean last;
        int blockIndex = this.blockIndex(index);
        boolean bl = last = blockIndex == this.blockCount - 1;
        if (last) {
            if (!this.blocks[blockIndex].add(index - this.offsets[blockIndex], element, false)) {
                this.addBlock();
                blockIndex = this.blockCount - 1;
                this.blocks[blockIndex].add(index - this.offsets[blockIndex], element, true);
            }
        } else {
            this.blocks[blockIndex].add(index - this.offsets[blockIndex], element, true);
            for (int idx = blockIndex + 1; idx < this.blockCount; ++idx) {
                int n = blockIndex;
                this.offsets[n] = this.offsets[n] + 1;
            }
        }
        ++this.size;
        return true;
    }

    public JRPrintElement set(int index, JRPrintElement element) {
        int blockIndex = this.blockIndex(index);
        return this.blocks[blockIndex].set(index - this.offsets[blockIndex], element);
    }

    public JRPrintElement remove(int index) {
        int idx;
        int blockIndex = this.blockIndex(index);
        ElementsBlock block = this.blocks[blockIndex];
        JRPrintElement element = block.remove(index - this.offsets[blockIndex]);
        if (blockIndex + 1 < this.blockCount) {
            idx = blockIndex + 1;
            while (idx < this.blockCount) {
                int n = idx++;
                this.offsets[n] = this.offsets[n] - 1;
            }
        }
        if (this.blockCount > 1 && block.isEmpty()) {
            for (idx = blockIndex + 1; idx < this.blockCount; ++idx) {
                this.blocks[idx - 1] = this.blocks[idx];
                this.offsets[idx - 1] = this.offsets[idx];
            }
            --this.blockCount;
            this.blocks[this.blockCount] = null;
            this.offsets[this.blockCount] = 0;
        }
        --this.size;
        return element;
    }

    public void dispose() {
        for (int idx = 0; idx < this.blockCount; ++idx) {
            this.blocks[idx].dispose();
        }
    }

    protected int blockIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (this.lastIndex >= 0 && this.lastIndex < this.blockCount && index >= this.offsets[this.lastIndex] && (this.lastIndex + 1 == this.blockCount || index < this.offsets[this.lastIndex + 1])) {
            return this.lastIndex;
        }
        int blockIndex = Arrays.binarySearch(this.offsets, 0, this.blockCount, index);
        if (blockIndex < 0) {
            blockIndex = -blockIndex - 2;
        }
        this.lastIndex = blockIndex;
        return blockIndex;
    }
}

