/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.SimpleFileResolver;

public abstract class AbstractClasspathAwareDataAdapterService
extends AbstractDataAdapterService {
    public AbstractClasspathAwareDataAdapterService(ClasspathAwareDataAdapter dataAdapter) {
        super(dataAdapter);
    }

    protected ClassLoader getClassLoader() {
        FileResolver fileResolver = JRResourcesUtil.getFileResolver(null);
        if (fileResolver == null) {
            SimpleFileResolver sfr = new SimpleFileResolver(new File("."));
            sfr.setResolveAbsolutePath(true);
            fileResolver = sfr;
        }
        ClasspathAwareDataAdapter dataAdapter = (ClasspathAwareDataAdapter)this.getDataAdapter();
        List<String> classpath = dataAdapter.getClasspath();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath) {
            File file = fileResolver.resolveFile(path);
            if (file == null || !file.exists()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

