/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        MapComponent map = (MapComponent)component;
        collector.addExpression(map.getLatitudeExpression());
        collector.addExpression(map.getLongitudeExpression());
        collector.addExpression(map.getZoomExpression());
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        MapComponent map = (MapComponent)component;
        return new StandardMapComponent(map, baseFactory);
    }

    public void verify(Component component, JRVerifier verifier) {
        MapComponent map = (MapComponent)component;
        EvaluationTimeEnum evaluationTime = map.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for maps", (Object)map);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = map.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for map", (Object)map);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Map evalution group \"" + evaluationGroup + " not found", (Object)map);
            }
        }
    }
}

