/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawChartRenderer
extends JRAbstractSvgRenderer
implements JRImageMapRenderer {
    private static final long serialVersionUID = 10200L;
    private JFreeChart chart;
    private ChartHyperlinkProvider chartHyperlinkProvider;

    public DrawChartRenderer(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider) {
        this.chart = chart;
        this.chartHyperlinkProvider = chartHyperlinkProvider;
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) {
        if (this.chart != null) {
            this.chart.draw(grx, rectangle);
        }
    }

    @Override
    public List<JRPrintImageAreaHyperlink> renderWithHyperlinks(Graphics2D grx, Rectangle2D rectangle) {
        this.render(grx, rectangle);
        return ChartUtil.getImageAreaHyperlinks(this.chart, this.chartHyperlinkProvider, grx, rectangle);
    }

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return ChartUtil.getImageAreaHyperlinks(this.chart, this.chartHyperlinkProvider, null, renderingArea);
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.chartHyperlinkProvider != null && this.chartHyperlinkProvider.hasHyperlinks();
    }
}

