/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.datatype;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.model.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberBase
extends Datatype {
    public static final Number UNBOUNDED_VALUE = Double.MAX_VALUE;
    public static final String UNBOUNDED_STRING = "unbounded";
    static List<Datatype.Facet> applicableFacets;
    private Datatype.Kind kind;
    private boolean hasFacets;
    private boolean isList;
    private List<Integer> totalDigits;
    private List<Integer> fractionDigits;
    private List<String> patterns;
    private List<Whitespace.Treatment> whitespaces;
    private List<Number> enumerations;
    private List<Number> maxInclusives;
    private List<Number> maxExclusives;
    private List<Number> minInclusives;
    private List<Number> minExclusives;

    public NumberBase(Datatype.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Datatype.Kind getKind() {
        return this.kind;
    }

    @Override
    public synchronized List<Datatype.Facet> getApplicableFacets() {
        if (applicableFacets == null) {
            ArrayList<Datatype.Facet> arrayList = new ArrayList<Datatype.Facet>();
            arrayList.add(Datatype.Facet.TOTATDIGITS);
            arrayList.add(Datatype.Facet.FRACTIONDIGITS);
            arrayList.add(Datatype.Facet.PATTERN);
            arrayList.add(Datatype.Facet.WHITESPACE);
            arrayList.add(Datatype.Facet.ENUMERATION);
            arrayList.add(Datatype.Facet.MAXINCLUSIVE);
            arrayList.add(Datatype.Facet.MAXEXCLUSIVE);
            arrayList.add(Datatype.Facet.MININCLUSIVE);
            arrayList.add(Datatype.Facet.MINEXCLUSIVE);
            applicableFacets = Collections.unmodifiableList(arrayList);
        }
        return applicableFacets;
    }

    @Override
    public boolean hasFacets() {
        return this.hasFacets;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public void setIsList(boolean bl) {
        this.isList = bl;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public List<Number> getEnumerations() {
        return this.enumerations;
    }

    @Override
    public List<Whitespace.Treatment> getWhiteSpaces() {
        return this.whitespaces;
    }

    public List<Integer> getTotalDigits() {
        return this.totalDigits;
    }

    public List<Integer> getFractionDigits() {
        return this.fractionDigits;
    }

    public List<Number> getMaxInclusives() {
        return this.maxInclusives;
    }

    public List<Number> getMaxExclusives() {
        return this.maxExclusives;
    }

    public List<Number> getMinInclusives() {
        return this.minInclusives;
    }

    public List<Number> getMinExclusives() {
        return this.minExclusives;
    }

    @Override
    public void addPattern(String string) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.patterns.add(string);
    }

    public void addEnumeration(Number number) {
        if (this.enumerations == null) {
            this.enumerations = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.enumerations.add(number);
    }

    @Override
    public void addWhitespace(Whitespace.Treatment treatment) {
        if (this.whitespaces == null) {
            this.whitespaces = new ArrayList<Whitespace.Treatment>(1);
            this.hasFacets = true;
        }
        this.whitespaces.add(treatment);
    }

    @Override
    public void addTotalDigits(int n) {
        if (this.totalDigits == null) {
            this.totalDigits = new ArrayList<Integer>(1);
            this.hasFacets = true;
        }
        this.totalDigits.add(new Integer(n));
    }

    @Override
    public void addFractionDigits(int n) {
        if (this.fractionDigits == null) {
            this.fractionDigits = new ArrayList<Integer>(1);
            this.hasFacets = true;
        }
        this.fractionDigits.add(new Integer(n));
    }

    public void addMaxInclusive(Number number) {
        if (this.maxInclusives == null) {
            this.maxInclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.maxInclusives.add(number);
    }

    public void addMaxExclusive(Number number) {
        if (this.maxExclusives == null) {
            this.maxExclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.maxExclusives.add(number);
    }

    public void addMinInclusive(Number number) {
        if (this.minInclusives == null) {
            this.minInclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.minInclusives.add(number);
    }

    public void addMinExclusive(Number number) {
        if (this.minExclusives == null) {
            this.minExclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.minExclusives.add(number);
    }

    @Override
    public void removePattern(String string) {
        if (this.patterns != null) {
            this.patterns.remove(string);
        }
    }

    public void removeEnumeration(Number number) {
        if (this.enumerations != null) {
            this.enumerations.remove(number);
        }
    }

    @Override
    public void removeWhitespace(Whitespace.Treatment treatment) {
        if (this.whitespaces != null) {
            this.whitespaces.remove(treatment);
        }
    }

    @Override
    public void removeTotalDigits(Number number) {
        if (this.totalDigits != null) {
            this.totalDigits.remove(number);
        }
    }

    @Override
    public void removeFractionDigits(Number number) {
        if (this.fractionDigits != null) {
            this.fractionDigits.remove(number);
        }
    }

    public void removeMaxInclusive(Number number) {
        if (this.maxInclusives != null) {
            this.maxInclusives.remove(number);
        }
    }

    public void removeMaxExclusive(Number number) {
        if (this.maxExclusives != null) {
            this.maxExclusives.remove(number);
        }
    }

    public void removeMinInclusive(Number number) {
        if (this.minInclusives != null) {
            this.minInclusives.remove(number);
        }
    }

    public void removeMinExclusive(Number number) {
        if (this.minExclusives != null) {
            this.minExclusives.remove(number);
        }
    }

    public static Number toNumber(String string) {
        Number number = null;
        if (string.equals(UNBOUNDED_STRING)) {
            number = UNBOUNDED_VALUE;
        } else {
            try {
                number = new BigDecimal(string);
            }
            catch (Throwable throwable) {
                number = 0;
            }
        }
        return number;
    }

    public static String toXMLString(Number number) {
        if (number == UNBOUNDED_VALUE) {
            return UNBOUNDED_STRING;
        }
        return String.valueOf(number);
    }
}

