/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.sort.properties;

import com.jaspersoft.ireport.components.sort.properties.SortFieldPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.design.JRDesignDataset;

public final class ColumnProperty
extends AbstractProperty {
    private final JRDesignDataset dataset;
    private final SortComponent component;
    private SortFieldPropertyEditor editor = null;

    public ColumnProperty(SortComponent component, JRDesignDataset dataset) {
        super(String.class, (Object)component);
        this.component = component;
        this.dataset = dataset;
        this.setValue("dataset", dataset);
        this.setValue("suppressCustomEditor", Boolean.FALSE);
        this.setValue("canEditAsText", false);
    }

    public String getName() {
        return "sortFieldName";
    }

    public String getDisplayName() {
        return I18n.getString((String)"Global.Property.Column");
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new SortFieldPropertyEditor();
        }
        return this.editor;
    }

    public Object getPropertyValue() {
        String field = this.component.getSortFieldName();
        if (field == null || field.length() == 0) {
            return null;
        }
        if (this.component.getSortFieldType() != null && this.component.getSortFieldType().equals("Variable")) {
            return "V" + field;
        }
        return "F" + field;
    }

    public Object getOwnPropertyValue() {
        return this.getPropertyValue();
    }

    public Object getDefaultValue() {
        return null;
    }

    public void validate(Object value) {
    }

    public void setPropertyValue(Object value) {
        if (value == null) {
            this.component.setSortFieldName(null);
            this.component.setSortFieldType(null);
        } else if (value instanceof String && ((String)value).startsWith("F")) {
            this.component.setSortFieldName(((String)value).substring(1));
            this.component.setSortFieldType("Field");
        } else if (value instanceof String && ((String)value).startsWith("V")) {
            this.component.setSortFieldName(((String)value).substring(1));
            this.component.setSortFieldType("Variable");
        } else {
            this.component.setSortFieldName(null);
            this.component.setSortFieldType(null);
        }
    }
}

