/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;

public class AddElementUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignElement element = null;
    private Object container = null;
    private int index = -1;

    public AddElementUndoableEdit(JRDesignElement element, Object container) {
        this.element = element;
        this.container = container;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this.container instanceof JRDesignElementGroup) {
            this.index = ((JRDesignElementGroup)this.container).getChildren().indexOf(this.element);
            ((JRDesignElementGroup)this.container).removeElement(this.element);
        } else if (this.container instanceof JRDesignFrame) {
            this.index = ((JRDesignFrame)this.container).getChildren().indexOf(this.element);
            ((JRDesignFrame)this.container).removeElement((JRElement)this.element);
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this.container instanceof JRDesignElementGroup) {
            JRDesignElementGroup cg = (JRDesignElementGroup)this.container;
            this.element.setElementGroup((JRElementGroup)cg);
            cg.getChildren().add(this.index, this.element);
            cg.getEventSupport().fireCollectionElementAddedEvent("children", (Object)this.element, cg.getChildren().size() - 1);
        } else if (this.container instanceof JRDesignFrame) {
            JRDesignFrame cg = (JRDesignFrame)this.container;
            this.element.setElementGroup((JRElementGroup)cg);
            cg.getChildren().add(this.index, this.element);
            cg.getEventSupport().fireCollectionElementAddedEvent("children", (Object)this.element, cg.getChildren().size() - 1);
        }
    }

    public String getPresentationName() {
        return "Add element";
    }

    public JRDesignElement getElement() {
        return this.element;
    }

    public void setElement(JRDesignElement element) {
        this.element = element;
    }
}

