/*
iReport - Visual Designer for JasperReports.
Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
http://www.jaspersoft.com

Unless you have purchased a commercial license agreement from Jaspersoft,
the following license terms apply:

This program is part of iReport.

iReport is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

iReport is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with iReport. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * SortFieldPickerPanel.java
 *
 * Created on 14-set-2011, 8.30.32
 */

package com.jaspersoft.ireport.components.sort.properties;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignVariable;



/**
 *
 * @author gtoffoli
 */
public class SortFieldPickerPanel extends javax.swing.JPanel {

    private static String PROPERTY_VALUE_SELECTED = "VALUE_SELECTED";
    
    private JRDesignDataset dataset = null;

    /** Creates new form SortFieldPickerPanel */
    public SortFieldPickerPanel() {
        initComponents();

        jList1.setCellRenderer(new SortFieldCellRenderer());
        jList1.setModel(new DefaultListModel());

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(SortFieldPickerPanel.class, "SortFieldPickerPanel.jLabel1.text")); // NOI18N

        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jList1MouseClicked(evt);
            }
        });
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged

        this.firePropertyChange(PROPERTY_VALUE_SELECTED, null, jList1.getSelectedValue());

    }//GEN-LAST:event_jList1ValueChanged

    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked
    }//GEN-LAST:event_jList1MouseClicked


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList jList1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the dataset
     */
    public JRDesignDataset getDataset() {
        return dataset;
    }

    /**
     * @param dataset the dataset to set
     */
    public void setDataset(JRDesignDataset dataset)
    {
        List newList = new ArrayList();
        newList.addAll(dataset.getFieldsList());
        newList.addAll(dataset.getVariablesList());

        Object[] objs = newList.toArray();

        Arrays.sort(objs, new Comparator() {

            public int compare(Object o1, Object o2) {

                String name1 = null;
                String name2 = null;
                if (o1 instanceof JRDesignField && o2 instanceof JRDesignVariable)
                {
                   return 1;
                }
                else if (o2 instanceof JRDesignField && o1 instanceof JRDesignVariable)
                {
                    return -1;
                }

                if (o1 instanceof JRDesignField)
                {
                    name1 = ((JRDesignField)o1).getName();
                }
                else if (o1 instanceof JRDesignVariable)
                {
                    name1 = ((JRDesignVariable)o1).getName();
                }
                if (o2 instanceof JRDesignField)
                {
                    name2 = ((JRDesignField)o1).getName();
                }
                if (o2 instanceof JRDesignVariable)
                {
                    name2 = ((JRDesignVariable)o1).getName();
                }

                if (name1 == null || name2 == null) return 0;

                return name1.compareToIgnoreCase(name2);
            }
        });

        this.dataset = dataset;

        DefaultListModel dlm = new DefaultListModel();
        for (Object obj : newList)
        {
            if (obj != null)
            {
                if (obj instanceof JRVariable)
                {
                    dlm.addElement("V" + ((JRVariable)obj).getName());
                }
                else if(obj instanceof JRField)
                {
                    dlm.addElement("F" + ((JRField)obj).getName());
                }
            }
        }
        jList1.setModel( dlm );
    }

    public void setSelectedValue(String obj)
    {
        // Select the correct value...
        jList1.setSelectedValue(obj, true);
    }

    public String getSelectedValue()
    {
        return (String)jList1.getSelectedValue();
    }

}
