/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractMultipartHttpServletRequest
extends HttpServletRequestWrapper
implements MultipartHttpServletRequest {
    private Map multipartFiles;

    protected AbstractMultipartHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public Iterator getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.getMultipartFiles().get(name);
    }

    public Map getFileMap() {
        return this.getMultipartFiles();
    }

    protected final void setMultipartFiles(Map multipartFiles) {
        this.multipartFiles = Collections.unmodifiableMap(multipartFiles);
    }

    protected Map getMultipartFiles() {
        if (this.multipartFiles == null) {
            this.initializeMultipart();
        }
        return this.multipartFiles;
    }

    protected void initializeMultipart() {
        throw new IllegalStateException("Multipart request not initialized");
    }
}

