/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class FoldingToolTip
extends JPanel {
    View view;
    EditorUI editorUI;
    public static final int BORDER_WIDTH = 2;

    public FoldingToolTip(View view, EditorUI editorUI) {
        this.view = view;
        this.editorUI = editorUI;
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)editorUI.getComponent())).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("default");
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        if (color == null) {
            color = Color.black;
        }
        this.setBorder(new LineBorder(color));
        this.setOpaque(true);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        int n3 = (int)this.view.getPreferredSpan(1);
        int n4 = (int)this.view.getPreferredSpan(0);
        if (n2 < 30) {
            this.putClientProperty(PopupManager.Placement.class, null);
        } else {
            n2 = Math.min(n2, n3);
        }
        n = Math.min(n, n4);
        super.setSize(n, n2 += 4);
    }

    private void updateRenderingHints(Graphics graphics) {
        String string;
        FontColorSettings fontColorSettings;
        Map map;
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent != null && (map = (Map)(fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)(string = DocumentUtilities.getMimeType((JTextComponent)jTextComponent))).lookup(FontColorSettings.class)).getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints)) != null) {
            ((Graphics2D)graphics).setRenderingHints(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintComponent(Graphics graphics) {
        this.updateRenderingHints(graphics);
        Rectangle rectangle = new Rectangle(this.getSize());
        Rectangle rectangle2 = graphics.getClipBounds();
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.editorUI.getComponent())).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("default");
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Background);
        if (color == null) {
            color = Color.white;
        }
        graphics.setColor(color);
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.translate(2, 2);
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        int n = this.editorUI.getSideBarWidth();
        GlyphGutter glyphGutter = this.editorUI.getGlyphGutter();
        if (glyphGutter != null) {
            block15: {
                View view = null;
                if (this.view.getViewCount() == 1) {
                    view = this.view.getView(0);
                }
                int n2 = 0;
                if (view != null) {
                    AbstractDocument abstractDocument = (AbstractDocument)view.getDocument();
                    abstractDocument.readLock();
                    try {
                        LockView lockView = LockView.get(view);
                        if (lockView == null) break block15;
                        lockView.lock();
                        try {
                            for (int i = 0; i < view.getViewCount(); n2 += this.editorUI.getLineHeight(), ++i) {
                                glyphGutter.paintGutterForView(graphics, view.getView(i), n2);
                            }
                            break block15;
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
                glyphGutter.paintGutterForView(graphics, this.view, 0);
            }
            graphics.translate(n, 0);
        }
        this.view.paint(graphics, rectangle);
        if (glyphGutter != null) {
            graphics.translate(-n, 0);
        }
        graphics.translate(-2, -2);
        graphics.setColor(color);
        int n3 = 1;
        while (n3 <= 2) {
            graphics.drawRect(rectangle2.x + n3, rectangle2.y + n3, rectangle2.width - n3 * 2 - 1, rectangle2.height - n3 * 2 - 1);
            ++n3;
        }
        return;
    }
}

