/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentElementHolder;
import org.hibernate.collection.PersistentSortedSet;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.SetType;

public class SortedSetType
extends SetType {
    private final Comparator comparator;

    public SortedSetType(String role, String propertyRef, Comparator comparator, boolean isEmbeddedInXML) {
        super(role, propertyRef, isEmbeddedInXML);
        this.comparator = comparator;
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister, Serializable key) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(session, persister, key);
        }
        PersistentSortedSet set = new PersistentSortedSet(session);
        set.setComparator(this.comparator);
        return set;
    }

    public Class getReturnedClass() {
        return SortedSet.class;
    }

    public Object instantiate(int anticipatedSize) {
        return new TreeSet(this.comparator);
    }

    public PersistentCollection wrap(SessionImplementor session, Object collection) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            return new PersistentElementHolder(session, (Element)collection);
        }
        return new PersistentSortedSet(session, (SortedSet)collection);
    }
}

