/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledTextParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRStyledTextAttributeSelector {
    public static final JRStyledTextAttributeSelector ALL = new JRStyledTextAttributeSelector(){

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            JRFontUtil.getAttributesWithoutAwtFont(attributes, printText);
            attributes.put(TextAttribute.FOREGROUND, printText.getForecolor());
            if (printText.getModeValue() == ModeEnum.OPAQUE) {
                attributes.put(TextAttribute.BACKGROUND, printText.getBackcolor());
            }
            return attributes;
        }
    };
    public static final JRStyledTextAttributeSelector NO_BACKCOLOR = new JRStyledTextAttributeSelector(){

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            JRFontUtil.getAttributesWithoutAwtFont(attributes, printText);
            attributes.put(TextAttribute.FOREGROUND, printText.getForecolor());
            return attributes;
        }
    };
    public static final JRStyledTextAttributeSelector NONE = new JRStyledTextAttributeSelector(){

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText printText) {
            return null;
        }
    };

    private static Locale getLocale() {
        return JRStyledTextParser.getLocale();
    }

    public static Locale getTextLocale(JRPrintText printText) {
        String localeCode = printText.getLocaleCode();
        if (localeCode == null) {
            return JRStyledTextAttributeSelector.getLocale();
        }
        return JRDataUtils.getLocale(localeCode);
    }

    public abstract Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes(JRPrintText var1);
}

