/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.BarbecueStyleResolver;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.ComponentContext;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardBarbecueComponent
implements BarbecueComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_CODE_EXPRESSION = "codeExpression";
    public static final String PROPERTY_APPLICATION_IDENTIFIER_EXPRESSION = "applicationIdentifierExpression";
    public static final String PROPERTY_DRAW_TEXT = "drawText";
    public static final String PROPERTY_CHECKSUM_REQUIRED = "checksumRequired";
    public static final String PROPERTY_BAR_WIDTH = "barWidth";
    public static final String PROPERTY_BAR_HEIGTH = "barHeight";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_ROTATION = "rotation";
    private String type;
    private JRExpression codeExpression;
    private JRExpression applicationIdentifierExpression;
    private boolean drawText;
    private boolean checksumRequired;
    private Integer barWidth;
    private Integer barHeight;
    private RotationEnum rotation;
    private EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private ComponentContext context;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40003;
    private byte evaluationTime;

    public StandardBarbecueComponent() {
    }

    public StandardBarbecueComponent(BarbecueComponent barcode, JRBaseObjectFactory objectFactory) {
        this.type = barcode.getType();
        this.codeExpression = objectFactory.getExpression(barcode.getCodeExpression());
        this.applicationIdentifierExpression = objectFactory.getExpression(barcode.getApplicationIdentifierExpression());
        this.drawText = barcode.isDrawText();
        this.checksumRequired = barcode.isChecksumRequired();
        this.barWidth = barcode.getBarWidth();
        this.barHeight = barcode.getBarHeight();
        this.evaluationTimeValue = barcode.getEvaluationTimeValue();
        this.evaluationGroup = barcode.getEvaluationGroup();
        this.rotation = barcode.getOwnRotation();
        this.context = new BaseComponentContext(barcode.getContext(), objectFactory);
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public JRExpression getCodeExpression() {
        return this.codeExpression;
    }

    public void setCodeExpression(JRExpression codeExpression) {
        JRExpression old = this.codeExpression;
        this.codeExpression = codeExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_CODE_EXPRESSION, old, this.codeExpression);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        String old = this.type;
        this.type = type;
        this.getEventSupport().firePropertyChange(PROPERTY_TYPE, old, this.type);
    }

    public JRExpression getApplicationIdentifierExpression() {
        return this.applicationIdentifierExpression;
    }

    public void setApplicationIdentifierExpression(JRExpression applicationIdentifierExpression) {
        JRExpression old = this.applicationIdentifierExpression;
        this.applicationIdentifierExpression = applicationIdentifierExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_APPLICATION_IDENTIFIER_EXPRESSION, old, this.applicationIdentifierExpression);
    }

    public Integer getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(Integer barWidth) {
        Integer old = this.barWidth;
        this.barWidth = barWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_BAR_WIDTH, old, this.barWidth);
    }

    public Integer getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(Integer barHeight) {
        Integer old = this.barHeight;
        this.barHeight = barHeight;
        this.getEventSupport().firePropertyChange(PROPERTY_BAR_HEIGTH, old, this.barHeight);
    }

    public RotationEnum getRotation() {
        return BarbecueStyleResolver.getRotationValue(this.getContext().getComponentElement());
    }

    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange(PROPERTY_ROTATION, old, this.rotation);
    }

    public boolean isChecksumRequired() {
        return this.checksumRequired;
    }

    public void setChecksumRequired(boolean checksumRequired) {
        boolean old = this.checksumRequired;
        this.checksumRequired = checksumRequired;
        this.getEventSupport().firePropertyChange(PROPERTY_CHECKSUM_REQUIRED, old, this.checksumRequired);
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        boolean old = this.drawText;
        this.drawText = drawText;
        this.getEventSupport().firePropertyChange(PROPERTY_DRAW_TEXT, old, this.drawText);
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    public void setEvaluationTimeValue(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTimeValue;
        this.evaluationTimeValue = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTimeValue);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        StandardBarbecueComponent standardBarbecueComponent = this;
        synchronized (standardBarbecueComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        StandardBarbecueComponent clone = null;
        try {
            clone = (StandardBarbecueComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.codeExpression = JRCloneUtils.nullSafeClone(this.codeExpression);
        clone.applicationIdentifierExpression = JRCloneUtils.nullSafeClone(this.applicationIdentifierExpression);
        clone.eventSupport = null;
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
    }
}

