/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Future;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jAbstractHttpProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxyException;
import org.olap4j.impl.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaOlap4jHttpProxy
extends XmlaOlap4jAbstractHttpProxy {
    private final XmlaOlap4jDriver driver;

    public XmlaOlap4jHttpProxy(XmlaOlap4jDriver driver) {
        this.driver = driver;
    }

    @Override
    public byte[] getResponse(URL url, String request) throws XmlaOlap4jProxyException {
        URLConnection urlConnection = null;
        try {
            int count;
            String encoding;
            urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestProperty("content-type", "text/xml");
            urlConnection.setRequestProperty("User-Agent", "Olap4j(".concat(this.driver.getVersion()).concat(")"));
            urlConnection.setRequestProperty("Accept", "text/xml;q=1");
            urlConnection.setRequestProperty("Accept-Charset", this.getEncodingCharsetName().concat(";q=1"));
            if (request.contains("<Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"")) {
                urlConnection.setRequestProperty("SOAPAction", "urn:schemas-microsoft-com:xml-analysis:Discover");
            } else if (request.contains("<Execute xmlns=\"urn:schemas-microsoft-com:xml-analysis\"")) {
                urlConnection.setRequestProperty("SOAPAction", "urn:schemas-microsoft-com:xml-analysis:Execute");
            }
            if (url.getUserInfo() != null) {
                encoding = Base64.encodeBytes(url.getUserInfo().getBytes(), 0);
                urlConnection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            this.useCookies(urlConnection);
            encoding = this.getEncodingCharsetName();
            urlConnection.getOutputStream().write(request.getBytes(encoding));
            InputStream is = urlConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((count = is.read(buf)) > 0) {
                baos.write(buf, 0, count);
            }
            this.saveCookies(urlConnection);
            return baos.toByteArray();
        }
        catch (Exception e) {
            try {
                int espCode = ((HttpURLConnection)urlConnection).getResponseCode();
                InputStream errorStream = ((HttpURLConnection)urlConnection).getErrorStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                if (errorStream != null) {
                    int count;
                    while ((count = errorStream.read(buf)) > 0) {
                        baos.write(buf, 0, count);
                    }
                    errorStream.close();
                }
                baos.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw new XmlaOlap4jProxyException("This proxy encountered an exception while processing the query.", e);
        }
    }

    @Override
    public Future<byte[]> getResponseViaSubmit(URL url, String request) {
        return XmlaOlap4jDriver.getFuture(this, url, request);
    }

    @Override
    public String getEncodingCharsetName() {
        return "UTF-8";
    }
}

