/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroShortcutsInjector
extends StorageFilter<Collection<KeyStroke>, MultiKeyBinding>
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MacroShortcutsInjector.class.getName());
    private static MacroShortcutsInjector instance = null;
    private EditorSettingsStorage<String, MacroDescription> storage = null;

    public static void refreshShortcuts() {
        assert (instance != null);
        LOG.fine("Shortcuts refresh forced, notifying 'Keybindings' storage...");
        instance.notifyChanges();
    }

    public MacroShortcutsInjector() {
        super("Keybindings");
        assert (instance == null);
        instance = this;
    }

    public void afterLoad(Map<Collection<KeyStroke>, MultiKeyBinding> map, MimePath mimePath, String string, boolean bl) {
        HashMap<String, MacroDescription> hashMap = new HashMap<String, MacroDescription>();
        this.collectMacroActions(mimePath, hashMap);
        for (MacroDescription macroDescription : hashMap.values()) {
            List<? extends MultiKeyBinding> list = macroDescription.getShortcuts();
            for (MultiKeyBinding multiKeyBinding : list) {
                List list2 = multiKeyBinding.getKeyStrokeList();
                if (!map.containsKey(list2)) {
                    map.put(list2, multiKeyBinding);
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("afterLoad: injecting " + list2 + " for macro '" + macroDescription.getName() + "'; mimePath='" + mimePath.getPath() + "'");
                    continue;
                }
                LOG.warning("Shortcut " + list2 + " is bound to '" + map.get(list2).getActionName() + "' for '" + mimePath.getPath() + "' and will not be assigned to '" + macroDescription.getName() + "' macro!");
            }
        }
    }

    public void beforeSave(Map<Collection<KeyStroke>, MultiKeyBinding> map, MimePath mimePath, String string, boolean bl) {
        HashSet<Collection<KeyStroke>> hashSet = new HashSet<Collection<KeyStroke>>();
        for (Collection<KeyStroke> collection : map.keySet()) {
            MultiKeyBinding multiKeyBinding = map.get(collection);
            if (!multiKeyBinding.getActionName().equals("run-macro")) continue;
            hashSet.add(collection);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("beforeSave: filtering out macro shortcut " + collection + "; mimePath='" + mimePath.getPath() + "'");
        }
        map.keySet().removeAll(hashSet);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null || "EditorSettingsStorage.PROP_DATA".equals(propertyChangeEvent.getPropertyName())) {
            LOG.fine("Macros storage changed, notifying 'Keybindings' storage...");
            this.notifyChanges();
        }
    }

    private void collectMacroActions(MimePath mimePath, Map<String, MacroDescription> map) {
        if (this.storage == null) {
            this.storage = EditorSettingsStorage.get((String)"Macros");
            this.storage.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, this.storage));
        }
        try {
            map.putAll(this.storage.load(mimePath, null, false));
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }
}

