/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MySqlDialect.class, Dialect.DatabaseProduct.MYSQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && !MySqlDialect.isInfobright(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public MySqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public static boolean isInfobright(DatabaseMetaData databaseMetaData) {
        Statement statement = null;
        try {
            ResultSet resultSet;
            String productVersion = databaseMetaData.getDatabaseProductVersion();
            if (productVersion.compareTo("5.1") >= 0 && (resultSet = (statement = databaseMetaData.getConnection().createStatement()).executeQuery("select * from INFORMATION_SCHEMA.engines where ENGINE = 'BRIGHTHOUSE'")).next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Brighthouse engine");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    protected String deduceProductName(DatabaseMetaData databaseMetaData) {
        String productName = super.deduceProductName(databaseMetaData);
        if (MySqlDialect.isInfobright(databaseMetaData)) {
            return "MySQL (Infobright)";
        }
        return productName;
    }

    @Override
    protected String deduceIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        String quoteIdentifierString = super.deduceIdentifierQuoteString(databaseMetaData);
        if (quoteIdentifierString == null) {
            quoteIdentifierString = "`";
        }
        return quoteIdentifierString;
    }

    @Override
    protected boolean deduceSupportsSelectNotInGroupBy(Connection connection) throws SQLException {
        boolean supported = false;
        String sqlmode = this.getCurrentSqlMode(connection);
        if (sqlmode == null) {
            supported = true;
        } else if (!sqlmode.contains("ONLY_FULL_GROUP_BY")) {
            supported = true;
        }
        return supported;
    }

    private String getCurrentSqlMode(Connection connection) throws SQLException {
        return this.getSqlMode(connection, Scope.SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSqlMode(Connection connection, Scope scope) throws SQLException {
        String sqlmode = null;
        Statement s = null;
        try {
            ResultSet rs;
            s = connection.createStatement();
            if (s.execute("SELECT @@" + (Object)((Object)scope) + ".sql_mode") && (rs = s.getResultSet()).next()) {
                sqlmode = rs.getString(1);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {}
            }
        }
        return sqlmode;
    }

    @Override
    public void appendHintsAfterFromClause(StringBuilder buf, Map<String, String> hints) {
        String forcedIndex;
        if (hints != null && (forcedIndex = hints.get("force_index")) != null) {
            buf.append(" FORCE INDEX (");
            buf.append(forcedIndex);
            buf.append(")");
        }
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return this.productVersion.compareTo("4.") >= 0;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return true;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public Dialect.NullCollation getNullCollation() {
        return Dialect.NullCollation.NEGINF;
    }

    @Override
    public String generateOrderItem(String expr, boolean nullable, boolean ascending) {
        if (nullable && ascending) {
            return "ISNULL(" + expr + "), " + expr + " ASC";
        }
        return super.generateOrderItem(expr, nullable, ascending);
    }

    @Override
    public boolean requiresOrderByAlias() {
        return true;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Scope {
        SESSION,
        GLOBAL;

    }
}

