/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.xml.RemoteXmlDataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapterService;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteXmlDataAdapterService
extends XmlDataAdapterService {
    public static final String XML_URL = "XML_URL";

    public RemoteXmlDataAdapterService(RemoteXmlDataAdapter remoteXmlDataAdapter) {
        super(remoteXmlDataAdapter);
    }

    public RemoteXmlDataAdapter getRemoteXmlDataAdapter() {
        return (RemoteXmlDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        RemoteXmlDataAdapter remoteXmlDataAdapter = this.getRemoteXmlDataAdapter();
        if (remoteXmlDataAdapter != null && remoteXmlDataAdapter.isUseConnection()) {
            String numberPattern;
            String datePattern;
            TimeZone timeZone;
            String fileName = remoteXmlDataAdapter.getFileName();
            System.out.println("Running against: " + fileName);
            System.out.flush();
            if (fileName.toLowerCase().startsWith("https://") || fileName.toLowerCase().startsWith("http://") || fileName.toLowerCase().startsWith("file:")) {
                parameters.put(XML_URL, fileName);
            } else {
                Document document = JRXmlUtils.parse(new File(fileName));
                parameters.put("XML_DATA_DOCUMENT", document);
            }
            Locale locale = remoteXmlDataAdapter.getLocale();
            if (locale != null) {
                parameters.put("XML_LOCALE", locale);
            }
            if ((timeZone = remoteXmlDataAdapter.getTimeZone()) != null) {
                parameters.put("XML_TIME_ZONE", timeZone);
            }
            if ((datePattern = remoteXmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                parameters.put("XML_DATE_PATTERN", datePattern);
            }
            if ((numberPattern = remoteXmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                parameters.put("XML_NUMBER_PATTERN", numberPattern);
            }
        }
    }

    @Override
    public void test() throws JRException {
        RemoteXmlDataAdapter remoteXmlDataAdapter = (RemoteXmlDataAdapter)this.getDataAdapter();
        URL url = null;
        InputStream is = null;
        try {
            String fileName = remoteXmlDataAdapter.getFileName();
            url = new URL(fileName);
            if (fileName.startsWith("file://")) {
                is = url.openStream();
            }
        }
        catch (Exception e) {
            throw new JRException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

