/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.test.FoodMartTestCase;

public class RaggedHierarchyTest
extends FoodMartTestCase {
    private void assertRaggedReturns(String expression, String expected) {
        this.getTestContext().withCube("[Sales Ragged]").assertAxisReturns(expression, expected);
    }

    public void testChildrenOfRoot() {
        this.assertRaggedReturns("[Store].children", "[Store].[All Stores].[Canada]" + nl + "[Store].[All Stores].[Israel]" + nl + "[Store].[All Stores].[Mexico]" + nl + "[Store].[All Stores].[USA]" + nl + "[Store].[All Stores].[Vatican]");
    }

    public void testChildrenOfUSA() {
        this.assertRaggedReturns("[Store].[USA].children", "[Store].[All Stores].[USA].[CA]" + nl + "[Store].[All Stores].[USA].[OR]" + nl + "[Store].[All Stores].[USA].[USA].[Washington]" + nl + "[Store].[All Stores].[USA].[WA]");
    }

    public void testChildrenOfIsrael() {
        this.assertRaggedReturns("[Store].[Israel].children", "[Store].[All Stores].[Israel].[Israel].[Haifa]" + nl + "[Store].[All Stores].[Israel].[Israel].[Tel Aviv]");
    }

    public void dont_testChildrenOfVatican() {
        this.assertRaggedReturns("[Store].[Vatican].children", "[Store].[All Stores].[Vatican].[Vatican].[null].[Store 17]");
    }

    public void testParentOfHaifa() {
        this.assertRaggedReturns("[Store].[Israel].[Haifa].Parent", "[Store].[All Stores].[Israel]");
    }

    public void testParentOfVatican() {
        this.assertRaggedReturns("[Store].[Vatican].Parent", "[Store].[All Stores]");
    }

    public void testPrevMemberOfHaifa() {
        this.assertRaggedReturns("[Store].[Israel].[Haifa].PrevMember", "[Store].[All Stores].[Canada].[BC].[Victoria]");
    }

    public void testNextMemberOfTelAviv() {
        this.assertRaggedReturns("[Store].[Israel].[Tel Aviv].NextMember", "[Store].[All Stores].[Mexico].[DF].[Mexico City]");
    }

    public void testNextMemberOfBC() {
        this.assertRaggedReturns("[Store].[All Stores].[Canada].[BC].NextMember", "[Store].[All Stores].[Mexico].[DF]");
    }

    public void testLead() {
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lead(1)", "[Store].[All Stores].[Mexico].[Guerrero]");
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lead(0)", "[Store].[All Stores].[Mexico].[DF]");
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lead(-1)", "[Store].[All Stores].[Canada].[BC]");
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lag(1)", "[Store].[All Stores].[Canada].[BC]");
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lead(-2)", "");
        this.assertRaggedReturns("[Store].[All Stores].[Mexico].[DF].Lead(-543)", "");
    }

    public void dont_testDescendantsOfVatican() {
        this.assertRaggedReturns("Descendants([Store].[Vatican])", "[Store].[All Stores].[Vatican]" + nl + "[Store].[All Stores].[Vatican].[Vatican].[null].[Store 17]");
    }

    public void testDescendantsOfVaticanAtStateLevel() {
        this.assertRaggedReturns("Descendants([Store].[Vatican], [Store].[Store State])", "");
    }

    public void testDescendantsOfRootAtCity() {
        this.assertRaggedReturns("Descendants([Store], [Store City])", "[Store].[All Stores].[Canada].[BC].[Vancouver]" + nl + "[Store].[All Stores].[Canada].[BC].[Victoria]" + nl + "[Store].[All Stores].[Israel].[Israel].[Haifa]" + nl + "[Store].[All Stores].[Israel].[Israel].[Tel Aviv]" + nl + "[Store].[All Stores].[Mexico].[DF].[Mexico City]" + nl + "[Store].[All Stores].[Mexico].[DF].[San Andres]" + nl + "[Store].[All Stores].[Mexico].[Guerrero].[Acapulco]" + nl + "[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara]" + nl + "[Store].[All Stores].[Mexico].[Veracruz].[Orizaba]" + nl + "[Store].[All Stores].[Mexico].[Yucatan].[Merida]" + nl + "[Store].[All Stores].[Mexico].[Zacatecas].[Camacho]" + nl + "[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo]" + nl + "[Store].[All Stores].[USA].[CA].[Alameda]" + nl + "[Store].[All Stores].[USA].[CA].[Beverly Hills]" + nl + "[Store].[All Stores].[USA].[CA].[Los Angeles]" + nl + "[Store].[All Stores].[USA].[CA].[San Francisco]" + nl + "[Store].[All Stores].[USA].[OR].[Portland]" + nl + "[Store].[All Stores].[USA].[OR].[Salem]" + nl + "[Store].[All Stores].[USA].[USA].[Washington]" + nl + "[Store].[All Stores].[USA].[WA].[Bellingham]" + nl + "[Store].[All Stores].[USA].[WA].[Bremerton]" + nl + "[Store].[All Stores].[USA].[WA].[Seattle]" + nl + "[Store].[All Stores].[USA].[WA].[Spokane]");
    }

    public void testAncestorOfHaifa() {
        this.assertRaggedReturns("Ancestor([Store].[Israel].[Haifa], [Store].[Store State])", "");
    }

    public void testHierarchize() {
        this.assertRaggedReturns("Hierarchize(Descendants([Store], [Store].[Store City], SELF_AND_BEFORE))", "[Store].[All Stores]" + nl + "[Store].[All Stores].[Canada]" + nl + "[Store].[All Stores].[Canada].[BC]" + nl + "[Store].[All Stores].[Canada].[BC].[Vancouver]" + nl + "[Store].[All Stores].[Canada].[BC].[Victoria]" + nl + "[Store].[All Stores].[Israel]" + nl + "[Store].[All Stores].[Israel].[Israel].[Haifa]" + nl + "[Store].[All Stores].[Israel].[Israel].[Tel Aviv]" + nl + "[Store].[All Stores].[Mexico]" + nl + "[Store].[All Stores].[Mexico].[DF]" + nl + "[Store].[All Stores].[Mexico].[DF].[Mexico City]" + nl + "[Store].[All Stores].[Mexico].[DF].[San Andres]" + nl + "[Store].[All Stores].[Mexico].[Guerrero]" + nl + "[Store].[All Stores].[Mexico].[Guerrero].[Acapulco]" + nl + "[Store].[All Stores].[Mexico].[Jalisco]" + nl + "[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara]" + nl + "[Store].[All Stores].[Mexico].[Veracruz]" + nl + "[Store].[All Stores].[Mexico].[Veracruz].[Orizaba]" + nl + "[Store].[All Stores].[Mexico].[Yucatan]" + nl + "[Store].[All Stores].[Mexico].[Yucatan].[Merida]" + nl + "[Store].[All Stores].[Mexico].[Zacatecas]" + nl + "[Store].[All Stores].[Mexico].[Zacatecas].[Camacho]" + nl + "[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo]" + nl + "[Store].[All Stores].[USA]" + nl + "[Store].[All Stores].[USA].[CA]" + nl + "[Store].[All Stores].[USA].[CA].[Alameda]" + nl + "[Store].[All Stores].[USA].[CA].[Beverly Hills]" + nl + "[Store].[All Stores].[USA].[CA].[Los Angeles]" + nl + "[Store].[All Stores].[USA].[CA].[San Francisco]" + nl + "[Store].[All Stores].[USA].[OR]" + nl + "[Store].[All Stores].[USA].[OR].[Portland]" + nl + "[Store].[All Stores].[USA].[OR].[Salem]" + nl + "[Store].[All Stores].[USA].[USA].[Washington]" + nl + "[Store].[All Stores].[USA].[WA]" + nl + "[Store].[All Stores].[USA].[WA].[Bellingham]" + nl + "[Store].[All Stores].[USA].[WA].[Bremerton]" + nl + "[Store].[All Stores].[USA].[WA].[Seattle]" + nl + "[Store].[All Stores].[USA].[WA].[Spokane]" + nl + "[Store].[All Stores].[Vatican]");
    }

    public void dont_testMeasuresVatican() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS," + nl + " {Descendants([Store].[Vatican])} ON ROWS" + nl + "FROM [Sales Ragged]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Axis #2:" + nl + "{[Store].[All Stores].[Vatican]}" + nl + "{[Store].[All Stores].[Vatican].[Vatican].[null].[Store 17]}" + nl + "Row #0: 35,257" + nl + "Row #1: 35,257" + nl);
    }

    public void dont_testMeasures() {
        this.assertQueryReturns("SELECT {[Measures].[Unit Sales]} ON COLUMNS," + nl + " NON EMPTY {Descendants([Store])} ON ROWS" + nl + "FROM [Sales Ragged]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[Unit Sales]}" + nl + "Axis #2:" + nl + "{[Store].[All Stores]}" + nl + "{[Store].[All Stores].[Israel]}" + nl + "{[Store].[All Stores].[Israel].[Israel].[Haifa]}" + nl + "{[Store].[All Stores].[Israel].[Israel].[Haifa].[Store 22]}" + nl + "{[Store].[All Stores].[Israel].[Israel].[Tel Aviv]}" + nl + "{[Store].[All Stores].[Israel].[Israel].[Tel Aviv].[Store 23]}" + nl + "{[Store].[All Stores].[USA]}" + nl + "{[Store].[All Stores].[USA].[CA]}" + nl + "{[Store].[All Stores].[USA].[CA].[Beverly Hills]}" + nl + "{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}" + nl + "{[Store].[All Stores].[USA].[CA].[Los Angeles]}" + nl + "{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}" + nl + "{[Store].[All Stores].[USA].[CA].[San Francisco]}" + nl + "{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}" + nl + "{[Store].[All Stores].[USA].[OR]}" + nl + "{[Store].[All Stores].[USA].[OR].[Portland]}" + nl + "{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}" + nl + "{[Store].[All Stores].[USA].[OR].[Salem]}" + nl + "{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}" + nl + "{[Store].[All Stores].[USA].[USA].[Washington]}" + nl + "{[Store].[All Stores].[USA].[USA].[Washington].[Store 24]}" + nl + "{[Store].[All Stores].[USA].[WA]}" + nl + "{[Store].[All Stores].[USA].[WA].[Bellingham]}" + nl + "{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}" + nl + "{[Store].[All Stores].[USA].[WA].[Bremerton]}" + nl + "{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}" + nl + "{[Store].[All Stores].[USA].[WA].[Seattle]}" + nl + "{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}" + nl + "{[Store].[All Stores].[USA].[WA].[Spokane]}" + nl + "{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}" + nl + "{[Store].[All Stores].[Vatican]}" + nl + "{[Store].[All Stores].[Vatican].[Vatican].[null].[Store 17]}" + nl + "Row #0: 266,773" + nl + "Row #1: 13,694" + nl + "Row #2: 2,203" + nl + "Row #3: 2,203" + nl + "Row #4: 11,491" + nl + "Row #5: 11,491" + nl + "Row #6: 217,822" + nl + "Row #7: 49,113" + nl + "Row #8: 21,333" + nl + "Row #9: 21,333" + nl + "Row #10: 25,663" + nl + "Row #11: 25,663" + nl + "Row #12: 2,117" + nl + "Row #13: 2,117" + nl + "Row #14: 67,659" + nl + "Row #15: 26,079" + nl + "Row #16: 26,079" + nl + "Row #17: 41,580" + nl + "Row #18: 41,580" + nl + "Row #19: 25,635" + nl + "Row #20: 25,635" + nl + "Row #21: 75,415" + nl + "Row #22: 2,237" + nl + "Row #23: 2,237" + nl + "Row #24: 24,576" + nl + "Row #25: 24,576" + nl + "Row #26: 25,011" + nl + "Row #27: 25,011" + nl + "Row #28: 23,591" + nl + "Row #29: 23,591" + nl + "Row #30: 35,257" + nl + "Row #31: 35,257" + nl);
    }
}

