/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintText;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRFillTextField
extends JRFillTextElement
implements JRTextField {
    private JRGroup evaluationGroup;
    private String anchorName;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;

    protected JRFillTextField(JRBaseFiller filler, JRTextField textField, JRFillObjectFactory factory) {
        super(filler, textField, factory);
        this.evaluationGroup = factory.getGroup(textField.getEvaluationGroup());
    }

    protected JRFillTextField(JRFillTextField textField, JRFillCloneFactory factory) {
        super(textField, factory);
        this.evaluationGroup = textField.evaluationGroup;
    }

    public boolean isStretchWithOverflow() {
        return ((JRTextField)this.parent).isStretchWithOverflow();
    }

    public void setStretchWithOverflow(boolean isStretchWithOverflow) {
    }

    public byte getEvaluationTime() {
        return this.getEvaluationTimeValue().getValue();
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRTextField)this.parent).getEvaluationTimeValue();
    }

    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    public String getOwnPattern() {
        return ((JRTextField)this.parent).getOwnPattern();
    }

    public void setPattern(String pattern) {
    }

    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    public Boolean isOwnBlankWhenNull() {
        return ((JRTextField)this.parent).isOwnBlankWhenNull();
    }

    public void setBlankWhenNull(boolean isBlank) {
    }

    public void setBlankWhenNull(Boolean isBlank) {
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRTextField)this.parent).getHyperlinkTypeValue();
    }

    public byte getHyperlinkTarget() {
        return ((JRTextField)this.parent).getHyperlinkTarget();
    }

    public String getLinkTarget() {
        return ((JRTextField)this.parent).getLinkTarget();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRExpression getExpression() {
        return ((JRTextField)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRTextField)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRTextField)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRTextField)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRTextField)this.parent).getHyperlinkPageExpression();
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateText getJRTemplateText() {
        return (JRTemplateText)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        JRTemplateText template = new JRTemplateText(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
        this.setTemplatePattern(template);
        return template;
    }

    protected void setTemplatePattern(JRTemplateText template) {
        Class valueClass;
        if (this.getExpression() != null && !String.class.equals((Object)(valueClass = this.getExpression().getValueClass()))) {
            template.setValueClassName(valueClass.getName());
            String pattern = this.getTemplatePattern();
            if (pattern != null) {
                template.setPattern(pattern);
            }
            if (!this.filler.hasMasterFormatFactory()) {
                template.setFormatFactoryClass(this.filler.getFormatFactory().getClass().getName());
            }
            if (!this.filler.hasMasterLocale()) {
                template.setLocaleCode(JRDataUtils.getLocaleCode(this.filler.getLocale()));
            }
            if (!this.filler.hasMasterTimeZone() && Date.class.isAssignableFrom(valueClass)) {
                template.setTimeZoneId(JRDataUtils.getTimeZoneId(this.filler.getTimeZone()));
            }
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateText(evaluation);
        }
    }

    protected void evaluateText(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        Object textFieldValue = this.evaluateExpression(this.getExpression(), evaluation);
        if (textFieldValue == null) {
            if (this.isBlankWhenNull()) {
                textFieldValue = "";
            }
        } else {
            Format format = this.getFormat();
            if (format != null) {
                textFieldValue = format.format(textFieldValue);
            }
        }
        String oldRawText = this.getRawText();
        String newRawText = this.processMarkupText(String.valueOf(textFieldValue));
        this.setRawText(newRawText);
        this.resetTextChunk();
        this.setValueRepeating(oldRawText == null && newRawText == null || oldRawText != null && oldRawText.equals(newRawText));
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.isEvaluateNow()) {
            if (isOverflow) {
                if (this.getPositionTypeValue() == PositionTypeEnum.FIX_RELATIVE_TO_BOTTOM) {
                    this.resetTextChunk();
                }
                if (!(this.getTextEnd() < this.getText().length() && this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE) || !this.isAlreadyPrinted())) {
                    if (this.isPrintWhenDetailOverflows()) {
                        this.resetTextChunk();
                        isReprinted = true;
                    } else {
                        isToPrint = false;
                    }
                }
                if (isToPrint && this.isPrintWhenExpressionNull() && !this.isPrintRepeatedValues() && this.isValueRepeating()) {
                    isToPrint = false;
                }
            } else if (!(!this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()))) {
                isToPrint = false;
            }
            if (isToPrint) {
                if (availableHeight >= this.getRelativeY() + this.getHeight()) {
                    if (this.getTextEnd() < this.getText().length() || this.getTextEnd() == 0) {
                        if (this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE)) {
                            this.chopTextElement(availableHeight - this.getRelativeY() - this.getHeight());
                            if (this.getTextEnd() < this.getText().length()) {
                                willOverflow = true;
                            }
                        } else {
                            this.chopTextElement(0);
                        }
                    } else {
                        isToPrint = false;
                    }
                } else {
                    isToPrint = false;
                    willOverflow = true;
                }
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getText().substring(this.getTextStart(), this.getTextEnd()).trim().length() == 0) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted()) {
                if (this.isPrintWhenDetailOverflows()) {
                    isReprinted = true;
                } else {
                    isToPrint = false;
                }
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintText text;
        JRRecordedValuesPrintText recordedValuesText;
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (this.isEvaluateAuto()) {
            recordedValuesText = new JRRecordedValuesPrintText(this.getJRTemplateText());
            text = recordedValuesText;
        } else {
            text = new JRTemplatePrintText(this.getJRTemplateText());
            recordedValuesText = null;
        }
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setWidth(this.getWidth());
        text.setHeight(this.getStretchHeight());
        text.setRunDirection(this.getRunDirectionValue());
        if (this.isEvaluateNow()) {
            this.copy(text);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(recordedValuesText);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)text, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return text;
    }

    protected void copy(JRPrintText text) {
        text.setTextHeight(this.getTextHeight());
        this.setPrintText(text);
        text.setAnchorName(this.getAnchorName());
        text.setHyperlinkReference(this.getHyperlinkReference());
        text.setHyperlinkAnchor(this.getHyperlinkAnchor());
        text.setHyperlinkPage(this.getHyperlinkPage());
        text.setHyperlinkTooltip(this.getHyperlinkTooltip());
        text.setBookmarkLevel(this.getBookmarkLevel());
        text.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(text);
    }

    protected Format getFormat() {
        Format format = null;
        JRExpression valueExpression = this.getExpression();
        if (valueExpression != null) {
            Class valueClass = valueExpression.getValueClass();
            if (Date.class.isAssignableFrom(valueClass)) {
                format = this.filler.getDateFormat(this.getPattern());
            } else if (Number.class.isAssignableFrom(valueClass)) {
                format = this.filler.getNumberFormat(this.getPattern());
            }
        }
        return format;
    }

    protected String getTemplatePattern() {
        String pattern = null;
        String originalPattern = this.getPattern();
        Format format = this.getFormat();
        JRExpression valueExpression = this.getExpression();
        if (format != null && valueExpression != null) {
            Class valueClass = valueExpression.getValueClass();
            if (Date.class.isAssignableFrom(valueClass)) {
                if (format instanceof SimpleDateFormat) {
                    pattern = ((SimpleDateFormat)format).toPattern();
                }
            } else if (Number.class.isAssignableFrom(valueClass) && format instanceof DecimalFormat) {
                pattern = ((DecimalFormat)format).toPattern();
            }
        }
        if (pattern == null) {
            pattern = originalPattern;
        }
        return pattern;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitTextField(this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateText(evaluation);
        this.chopTextElement(0);
        this.copy((JRPrintText)element);
    }

    public int getBookmarkLevel() {
        return ((JRTextField)this.parent).getBookmarkLevel();
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillTextField(this, factory);
    }

    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRTextField)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRTextField)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRTextField)this.parent).getHyperlinkTooltipExpression();
    }

    protected boolean canOverflow() {
        return this.isStretchWithOverflow() && this.getRotationValue().equals(RotationEnum.NONE) && this.isEvaluateNow() && this.filler.isBandOverFlowAllowed();
    }
}

