/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.TabSegment;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRProperties;

public class PdfTextRenderer
extends AbstractTextRenderer {
    private JRPdfExporter pdfExporter;
    private PdfContentByte pdfContentByte;
    private int horizontalAlignment;

    public static PdfTextRenderer getInstance() {
        return new PdfTextRenderer(JRProperties.getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
    }

    public PdfTextRenderer(boolean ignoreMissingFont) {
        super(false, ignoreMissingFont);
    }

    public void initialize(JRPdfExporter pdfExporter, PdfContentByte pdfContentByte, JRPrintText text, int offsetX, int offsetY) {
        this.pdfExporter = pdfExporter;
        this.pdfContentByte = pdfContentByte;
        this.horizontalAlignment = 0;
        switch (text.getHorizontalAlignmentValue()) {
            case LEFT: {
                if (text.getRunDirectionValue() == RunDirectionEnum.LTR) {
                    this.horizontalAlignment = 0;
                    break;
                }
                this.horizontalAlignment = 2;
                break;
            }
            case CENTER: {
                this.horizontalAlignment = 1;
                break;
            }
            case RIGHT: {
                if (text.getRunDirectionValue() == RunDirectionEnum.LTR) {
                    this.horizontalAlignment = 2;
                    break;
                }
                this.horizontalAlignment = 0;
                break;
            }
            case JUSTIFIED: {
                this.horizontalAlignment = 8;
                break;
            }
            default: {
                this.horizontalAlignment = 0;
            }
        }
        super.initialize(text, offsetX, offsetY);
    }

    public void draw() {
        TabSegment segment = (TabSegment)this.segments.get(this.segmentIndex);
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.pdfExporter.getPhrase(segment.as, segment.text, this.text), (float)(this.x + this.leftPadding) + this.drawPosX, (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset + this.lineHeight - this.drawPosY, (float)(this.x + this.leftPadding) + this.drawPosX + segment.layout.getAdvance(), (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - 400.0f - this.drawPosY, 0.0f, this.horizontalAlignment);
        colText.setLeading(this.lineHeight);
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

