/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public abstract class JRBaseTextElement
extends JRBaseElement
implements JRTextElement {
    private static final long serialVersionUID = 10200L;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected RotationEnum rotationValue;
    protected String markup;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;
    protected JRReportFont reportFont;
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Integer fontSize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    private int PSEUDO_SERIAL_VERSION_UID = 40002;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte rotation;
    private Byte lineSpacing;
    private LineSpacingEnum lineSpacingValue;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;

    protected JRBaseTextElement(JRTextElement textElement, JRBaseObjectFactory factory) {
        super(textElement, factory);
        this.horizontalAlignmentValue = textElement.getOwnHorizontalAlignmentValue();
        this.verticalAlignmentValue = textElement.getOwnVerticalAlignmentValue();
        this.rotationValue = textElement.getOwnRotationValue();
        this.markup = textElement.getOwnMarkup();
        this.lineBox = textElement.getLineBox().clone(this);
        this.paragraph = textElement.getParagraph().clone(this);
        this.reportFont = factory.getReportFont(textElement.getReportFont());
        this.fontName = textElement.getOwnFontName();
        this.isBold = textElement.isOwnBold();
        this.isItalic = textElement.isOwnItalic();
        this.isUnderline = textElement.isOwnUnderline();
        this.isStrikeThrough = textElement.isOwnStrikeThrough();
        this.fontSize = textElement.getOwnFontSize();
        this.pdfFontName = textElement.getOwnPdfFontName();
        this.pdfEncoding = textElement.getOwnPdfEncoding();
        this.isPdfEmbedded = textElement.isOwnPdfEmbedded();
    }

    protected JRFont getBaseFont() {
        if (this.reportFont != null) {
            return this.reportFont;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultFont();
        }
        return null;
    }

    public byte getTextAlignment() {
        return this.getHorizontalAlignment();
    }

    public void setTextAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(new Byte(horizontalAlignment));
    }

    public byte getHorizontalAlignment() {
        return this.getHorizontalAlignmentValue().getValue();
    }

    public Byte getOwnHorizontalAlignment() {
        return this.getOwnHorizontalAlignmentValue() == null ? null : this.getOwnHorizontalAlignmentValue().getValueByte();
    }

    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    public void setHorizontalAlignment(byte horizontalAlignment) {
        this.setHorizontalAlignment(HorizontalAlignEnum.getByValue(horizontalAlignment));
    }

    public void setHorizontalAlignment(Byte horizontalAlignment) {
        this.setHorizontalAlignment(HorizontalAlignEnum.getByValue(horizontalAlignment));
    }

    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        HorizontalAlignEnum old = this.horizontalAlignmentValue;
        this.horizontalAlignmentValue = horizontalAlignmentValue;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignmentValue);
    }

    public byte getVerticalAlignment() {
        return this.getVerticalAlignmentValue().getValue();
    }

    public Byte getOwnVerticalAlignment() {
        return this.getOwnVerticalAlignmentValue() == null ? null : this.getOwnVerticalAlignmentValue().getValueByte();
    }

    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    public void setVerticalAlignment(byte verticalAlignment) {
        this.setVerticalAlignment(VerticalAlignEnum.getByValue(verticalAlignment));
    }

    public void setVerticalAlignment(Byte verticalAlignment) {
        this.setVerticalAlignment(VerticalAlignEnum.getByValue(verticalAlignment));
    }

    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        VerticalAlignEnum old = this.verticalAlignmentValue;
        this.verticalAlignmentValue = verticalAlignmentValue;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignmentValue);
    }

    public byte getRotation() {
        return this.getRotationValue().getValue();
    }

    public Byte getOwnRotation() {
        return this.getOwnRotationValue() == null ? null : this.getOwnRotationValue().getValueByte();
    }

    public void setRotation(byte rotation) {
        this.setRotation(RotationEnum.getByValue(rotation));
    }

    public void setRotation(Byte rotation) {
        this.setRotation(RotationEnum.getByValue(rotation));
    }

    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    public void setRotation(RotationEnum rotationValue) {
        RotationEnum old = this.rotationValue;
        this.rotationValue = rotationValue;
        this.getEventSupport().firePropertyChange("rotation", old, this.rotationValue);
    }

    public byte getLineSpacing() {
        return this.getParagraph().getLineSpacing().getValue();
    }

    public Byte getOwnLineSpacing() {
        return this.getParagraph().getOwnLineSpacing() == null ? null : this.getParagraph().getOwnLineSpacing().getValueByte();
    }

    public void setLineSpacing(byte lineSpacing) {
        this.getParagraph().setLineSpacing(LineSpacingEnum.getByValue(lineSpacing));
    }

    public void setLineSpacing(Byte lineSpacing) {
        this.getParagraph().setLineSpacing(LineSpacingEnum.getByValue(lineSpacing));
    }

    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        this.getParagraph().setLineSpacing(lineSpacing);
    }

    public boolean isStyledText() {
        return "styled".equals(this.getMarkup());
    }

    public Boolean isOwnStyledText() {
        String mkp = this.getOwnMarkup();
        return "styled".equals(mkp) ? Boolean.TRUE : (mkp == null ? null : Boolean.FALSE);
    }

    public void setStyledText(boolean isStyledText) {
        this.setStyledText(isStyledText ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStyledText(Boolean isStyledText) {
        if (isStyledText == null) {
            this.setMarkup(null);
        } else {
            this.setMarkup(isStyledText != false ? "styled" : "none");
        }
    }

    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    public String getOwnMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        String old = this.markup;
        this.markup = markup;
        this.getEventSupport().firePropertyChange("markup", old, this.markup);
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    public JRFont getFont() {
        return this;
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public JRReportFont getReportFont() {
        return this.reportFont;
    }

    public void setReportFont(JRReportFont reportFont) {
        JRReportFont old = this.reportFont;
        this.reportFont = reportFont;
        this.getEventSupport().firePropertyChange("reportFont", old, this.reportFont);
    }

    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    public String getOwnFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        String old = this.fontName;
        this.fontName = fontName;
        this.getEventSupport().firePropertyChange("fontName", old, this.fontName);
    }

    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    public Boolean isOwnBold() {
        return this.isBold;
    }

    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBold(Boolean isBold) {
        Boolean old = this.isBold;
        this.isBold = isBold;
        this.getEventSupport().firePropertyChange("bold", old, this.isBold);
    }

    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setItalic(Boolean isItalic) {
        Boolean old = this.isItalic;
        this.isItalic = isItalic;
        this.getEventSupport().firePropertyChange("italic", old, this.isItalic);
    }

    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUnderline(Boolean isUnderline) {
        Boolean old = this.isUnderline;
        this.isUnderline = isUnderline;
        this.getEventSupport().firePropertyChange("underline", old, this.isUnderline);
    }

    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrikeThrough(Boolean isStrikeThrough) {
        Boolean old = this.isStrikeThrough;
        this.isStrikeThrough = isStrikeThrough;
        this.getEventSupport().firePropertyChange("strikeThrough", old, this.isStrikeThrough);
    }

    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    public Integer getOwnFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.setFontSize((Integer)fontSize);
    }

    public void setFontSize(Integer fontSize) {
        Integer old = this.fontSize;
        this.fontSize = fontSize;
        this.getEventSupport().firePropertyChange("fontSize", old, this.fontSize);
    }

    public int getSize() {
        return this.getFontSize();
    }

    public Integer getOwnSize() {
        return this.getOwnFontSize();
    }

    public void setSize(int size) {
        this.setFontSize(size);
    }

    public void setSize(Integer size) {
        this.setFontSize(size);
    }

    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    public void setPdfFontName(String pdfFontName) {
        String old = this.pdfFontName;
        this.pdfFontName = pdfFontName;
        this.getEventSupport().firePropertyChange("pdfFontName", old, this.pdfFontName);
    }

    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    public void setPdfEncoding(String pdfEncoding) {
        String old = this.pdfEncoding;
        this.pdfEncoding = pdfEncoding;
        this.getEventSupport().firePropertyChange("pdfEncoding", old, this.pdfEncoding);
    }

    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        Boolean old = this.isPdfEmbedded;
        this.isPdfEmbedded = isPdfEmbedded;
        this.getEventSupport().firePropertyChange("pdfEmbedded", old, this.isPdfEmbedded);
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRBaseTextElement clone = (JRBaseTextElement)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.paragraph = this.paragraph.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.paragraph == null) {
            this.paragraph = new JRBaseParagraph(this);
            this.paragraph.setLineSpacing(this.lineSpacingValue);
            this.lineSpacingValue = null;
        }
    }
}

