/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.BandTypeEnum;

public class JROrigin
implements JRCloneable,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final byte UNKNOWN = 0;
    public static final byte BACKGROUND = 1;
    public static final byte TITLE = 2;
    public static final byte PAGE_HEADER = 3;
    public static final byte COLUMN_HEADER = 4;
    public static final byte GROUP_HEADER = 5;
    public static final byte DETAIL = 6;
    public static final byte GROUP_FOOTER = 7;
    public static final byte COLUMN_FOOTER = 8;
    public static final byte PAGE_FOOTER = 9;
    public static final byte LAST_PAGE_FOOTER = 10;
    public static final byte SUMMARY = 11;
    public static final byte NO_DATA = 12;
    private BandTypeEnum bandTypeValue = BandTypeEnum.UNKNOWN;
    private String groupName;
    private String reportName;
    private transient Integer hashCode;
    private int PSEUDO_SERIAL_VERSION_UID = 40002;
    private byte bandType;

    public JROrigin(BandTypeEnum bandType) {
        this(null, null, bandType);
    }

    public JROrigin(String reportName, BandTypeEnum bandType) {
        this(reportName, null, bandType);
    }

    public JROrigin(String reportName, String groupName, BandTypeEnum bandTypeValue) {
        this.reportName = reportName;
        this.groupName = groupName;
        this.bandTypeValue = bandTypeValue;
    }

    public JROrigin(byte bandType) {
        this(null, null, BandTypeEnum.getByValue(bandType));
    }

    public JROrigin(String reportName, byte bandType) {
        this(reportName, null, BandTypeEnum.getByValue(bandType));
    }

    public JROrigin(String reportName, String groupName, byte bandType) {
        this(reportName, groupName, BandTypeEnum.getByValue(bandType));
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public byte getBandType() {
        return this.getBandTypeValue().getValue();
    }

    public BandTypeEnum getBandTypeValue() {
        return this.bandTypeValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JROrigin) {
            JROrigin origin = (JROrigin)obj;
            String groupName2 = origin.getGroupName();
            String reportName2 = origin.getReportName();
            return origin.getBandTypeValue() == this.bandTypeValue && (this.groupName == null ? groupName2 == null : groupName2 != null && this.groupName.equals(groupName2)) && (this.reportName == null ? reportName2 == null : reportName2 != null && this.reportName.equals(reportName2));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hash = 17;
            hash = 31 * hash + (this.reportName == null ? 0 : this.reportName.hashCode());
            hash = 31 * hash + (this.groupName == null ? 0 : this.groupName.hashCode());
            hash = 31 * hash + this.bandTypeValue.hashCode();
            this.hashCode = new Integer(hash);
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.bandTypeValue = BandTypeEnum.getByValue(this.bandType);
        }
    }
}

