/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.netbeans.modules.options.indentation.CustomizerSelector;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class FormattingPanel
extends JPanel
implements PropertyChangeListener {
    private JComboBox categoryCombo;
    private JLabel categoryLabel;
    private JPanel categoryPanel;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JPanel optionsPanel;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JScrollPane previewScrollPane;
    private CustomizerSelector selector;
    private PropertyChangeListener weakListener;

    public FormattingPanel() {
        this.initComponents();
        this.languageCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof String) {
                    object = ((String)object).length() > 0 ? EditorSettings.getDefault().getLanguageName((String)object) : NbBundle.getMessage(FormattingPanel.class, (String)"LBL_AllLanguages");
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.categoryCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof PreferencesCustomizer) {
                    object = ((PreferencesCustomizer)object).getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
    }

    public void setSelector(CustomizerSelector customizerSelector) {
        if (this.selector != null) {
            this.selector.removePropertyChangeListener(this.weakListener);
        }
        this.selector = customizerSelector;
        if (this.selector != null) {
            this.weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.selector);
            this.selector.addPropertyChangeListener(this.weakListener);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            ArrayList<? extends String> arrayList = new ArrayList<String>();
            arrayList.addAll(customizerSelector.getMimeTypes());
            Collections.sort(arrayList, new LanguagesComparator());
            for (String string2 : arrayList) {
                defaultComboBoxModel.addElement(string2);
            }
            this.languageCombo.setModel(defaultComboBoxModel);
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            String string = jTextComponent != null ? (String)jTextComponent.getDocument().getProperty("mimeType") : "";
            this.languageCombo.setSelectedItem(string);
            if (string != this.languageCombo.getSelectedItem()) {
                this.languageCombo.setSelectedIndex(0);
            }
        } else {
            this.languageCombo.setModel(new DefaultComboBoxModel());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2;
        Object object3;
        if (propertyChangeEvent.getPropertyName() == null || "CustomizerSelector.PROP_MIMETYPE".equals(propertyChangeEvent.getPropertyName())) {
            object3 = new DefaultComboBoxModel<PreferencesCustomizer>();
            object2 = this.selector.getCustomizers(this.selector.getSelectedMimeType());
            object = object2.iterator();
            while (object.hasNext()) {
                PreferencesCustomizer preferencesCustomizer = object.next();
                ((DefaultComboBoxModel)object3).addElement(preferencesCustomizer);
            }
            this.categoryCombo.setModel(object3);
            this.categoryCombo.setSelectedIndex(0);
        }
        if (propertyChangeEvent.getPropertyName() == null || "CustomizerSelector.PROP_CUSTOMIZER".equals(propertyChangeEvent.getPropertyName())) {
            this.categoryPanel.setVisible(false);
            this.categoryPanel.removeAll();
            this.previewScrollPane.setVisible(false);
            object3 = this.selector.getSelectedCustomizer();
            if (object3 != null) {
                this.categoryPanel.add((Component)object3.getComponent(), "Center");
            }
            this.categoryPanel.setVisible(true);
            if (object3 instanceof PreviewProvider) {
                object2 = ((PreviewProvider)object3).getPreviewComponent();
                ((JComponent)object2).setDoubleBuffered(true);
                if (object2 instanceof JTextComponent) {
                    object = ((JTextComponent)object2).getDocument();
                    object.putProperty("Tools-Options->Editor->Formatting->Preview - Preferences", this.selector.getCustomizerPreferences((PreferencesCustomizer)object3));
                }
            } else {
                object = new JLabel(NbBundle.getMessage(FormattingPanel.class, (String)"MSG_no_preview_available"));
                ((JComponent)object).setOpaque(true);
                ((JLabel)object).setHorizontalAlignment(0);
                ((JComponent)object).setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
                ((JComponent)object).setVisible(true);
                object2 = new JPanel(new BorderLayout());
                ((Container)object2).add((Component)object, "Center");
            }
            this.previewScrollPane.setViewportView((Component)object2);
            this.previewScrollPane.setVisible(true);
            if (object3 instanceof PreviewProvider) {
                object = (PreviewProvider)object3;
                SwingUtilities.invokeLater(new Runnable((PreviewProvider)object){
                    final /* synthetic */ PreviewProvider val$pp;
                    {
                        this.val$pp = previewProvider;
                    }

                    public void run() {
                        this.val$pp.refreshPreview();
                    }
                });
            }
        }
    }

    private void initComponents() {
        this.optionsPanel = new JPanel();
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox();
        this.categoryLabel = new JLabel();
        this.categoryCombo = new JComboBox();
        this.categoryPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.previewLabel = new JLabel();
        this.previewScrollPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.optionsPanel.setOpaque(false);
        this.languageLabel.setLabelFor(this.languageCombo);
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(FormattingPanel.class, (String)"LBL_Language"));
        this.languageCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.languageCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingPanel.this.languageChanged(actionEvent);
            }
        });
        this.categoryLabel.setLabelFor(this.categoryCombo);
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)NbBundle.getMessage(FormattingPanel.class, (String)"LBL_Category"));
        this.categoryCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.categoryCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingPanel.this.categoryChanged(actionEvent);
            }
        });
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this.optionsPanel);
        this.optionsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.categoryPanel, -1, 143, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.categoryLabel).add((Component)this.languageLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.languageCombo, -2, -1, -2).add((Component)this.categoryCombo, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.categoryCombo, this.languageCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.categoryLabel).add((Component)this.categoryCombo, -2, -1, -2)).add(18, 18, 18).add((Component)this.categoryPanel, -1, 266, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.optionsPanel, gridBagConstraints);
        this.previewPanel.setMinimumSize(new Dimension(150, 100));
        this.previewPanel.setOpaque(false);
        this.previewPanel.setPreferredSize(new Dimension(150, 100));
        this.previewPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(FormattingPanel.class, (String)"LBL_Preview"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.previewPanel.add((Component)this.previewLabel, gridBagConstraints);
        this.previewScrollPane.setDoubleBuffered(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.previewPanel.add((Component)this.previewScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.previewPanel, gridBagConstraints);
    }

    private void languageChanged(ActionEvent actionEvent) {
        this.selector.setSelectedMimeType((String)this.languageCombo.getSelectedItem());
    }

    private void categoryChanged(ActionEvent actionEvent) {
        this.selector.setSelectedCustomizer(((PreferencesCustomizer)this.categoryCombo.getSelectedItem()).getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguagesComparator
    implements Comparator<String> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string.length() == 0) {
                return string2.length() == 0 ? 0 : -1;
            }
            if (string2.length() == 0) {
                return 1;
            }
            String string3 = EditorSettings.getDefault().getLanguageName(string);
            String string4 = EditorSettings.getDefault().getLanguageName(string2);
            return string3.compareTo(string4);
        }
    }
}

