/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.components.table.undo.TableCellResizeUndoableEdit;
import com.jaspersoft.ireport.components.table.widgets.TableCellSeparatorWidget;
import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;

public class SeparatorDblClickResizeAction
extends WidgetAction.Adapter {
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 2 && widget instanceof TableCellSeparatorWidget) {
            JRDesignElement ele;
            int i;
            List children;
            int base;
            Rectangle bounds;
            TableCellSeparatorWidget separator = (TableCellSeparatorWidget)widget;
            TableObjectScene scene = (TableObjectScene)separator.getScene();
            List<TableCell> cells = scene.getTableMatrix().getCells();
            TableMatrix matrix = scene.getTableMatrix();
            int delta = 0;
            ArrayList<TableCellResizeUndoableEdit> undos = new ArrayList<TableCellResizeUndoableEdit>();
            if (separator.getOrientation() == SeparatorWidget.Orientation.HORIZONTAL) {
                delta = -matrix.getHorizontalSeparators().get(separator.getIndex()).intValue();
                for (TableCell cell : cells) {
                    if (cell.getRow() + cell.getRowSpan() != separator.getIndex()) continue;
                    bounds = matrix.getCellBounds(cell);
                    if (cell.getCell() != null) {
                        base = bounds.y;
                        int currentBottom = bounds.y + bounds.height;
                        int bestCellHeight = 0;
                        children = cell.getCell().getChildren();
                        for (i = 0; i < children.size(); ++i) {
                            if (!(children.get(i) instanceof JRDesignElement) || (ele = (JRDesignElement)children.get(i)).getY() + ele.getHeight() <= bestCellHeight) continue;
                            bestCellHeight = ele.getY() + ele.getHeight();
                        }
                        if (bestCellHeight == 0 && bestCellHeight - delta <= 0) {
                            bestCellHeight = bounds.height;
                        }
                        if (delta >= bestCellHeight - bounds.height) continue;
                        delta = bestCellHeight - bounds.height;
                        continue;
                    }
                    if (delta >= -bounds.height) continue;
                    delta = -bounds.height;
                }
                if (delta != 0) {
                    DesignCell firstNotNullCell = null;
                    for (TableCell cell : cells) {
                        if (cell.getRow() + cell.getRowSpan() != separator.getIndex() || cell.getCell() == null) continue;
                        if (firstNotNullCell == null) {
                            firstNotNullCell = cell.getCell();
                        }
                        int oldHeight = matrix.getHorizontalSeparators().get(separator.getIndex()) - matrix.getHorizontalSeparators().get(cell.getRow());
                        int newHeight = oldHeight + delta;
                        oldHeight = cell.getCell().getHeight();
                        cell.getCell().setHeight(Integer.valueOf(newHeight));
                        undos.add(new TableCellResizeUndoableEdit(scene.getTable(), scene.getJasperDesign(), cell.getCell(), "Height", Integer.class, oldHeight, newHeight));
                    }
                    if (firstNotNullCell != null) {
                        firstNotNullCell.getEventSupport().firePropertyChange("ROW_HEIGHT", null, (Object)0);
                    }
                    return WidgetAction.State.CONSUMED;
                }
            } else {
                delta = -matrix.getVerticalSeparators().get(separator.getIndex()).intValue();
                for (TableCell cell : cells) {
                    if (cell.getCol() + cell.getColSpan() != separator.getIndex()) continue;
                    bounds = matrix.getCellBounds(cell);
                    if (cell.getCell() != null) {
                        base = bounds.x;
                        int currentRight = bounds.x + bounds.width;
                        int bestCellWidth = 0;
                        children = cell.getCell().getChildren();
                        for (i = 0; i < children.size(); ++i) {
                            if (!(children.get(i) instanceof JRDesignElement) || (ele = (JRDesignElement)children.get(i)).getX() + ele.getWidth() <= bestCellWidth) continue;
                            bestCellWidth = ele.getX() + ele.getWidth();
                        }
                        if (bestCellWidth == 0 && bestCellWidth - delta <= 0) {
                            bestCellWidth = bounds.width;
                        }
                        if (delta >= bestCellWidth - bounds.width) continue;
                        delta = bestCellWidth - bounds.width;
                        continue;
                    }
                    if (delta >= -bounds.width) continue;
                    delta = -bounds.width;
                }
                if (delta != 0) {
                    StandardBaseColumn firstNotNullColumn = null;
                    for (TableCell cell : cells) {
                        if (cell.getType() != 0 || cell.getCol() + cell.getColSpan() != separator.getIndex()) continue;
                        int oldWidth = matrix.getVerticalSeparators().get(separator.getIndex()) - matrix.getVerticalSeparators().get(cell.getCol());
                        int newWidth = oldWidth + delta;
                        oldWidth = cell.getColumn().getWidth();
                        ((StandardBaseColumn)cell.getColumn()).setWidth(Integer.valueOf(newWidth));
                        firstNotNullColumn = (StandardBaseColumn)cell.getColumn();
                        undos.add(new TableCellResizeUndoableEdit(scene.getTable(), scene.getJasperDesign(), (StandardBaseColumn)cell.getColumn(), "Width", Integer.class, oldWidth, newWidth));
                    }
                    if (firstNotNullColumn != null) {
                        firstNotNullColumn.getEventSupport().firePropertyChange("COLUMN_WIDTH", null, (Object)0);
                    }
                }
            }
            if (delta != 0 && undos.size() > 0) {
                TableCellResizeUndoableEdit mainUndo = (TableCellResizeUndoableEdit)((Object)undos.get(0));
                mainUndo.setMain(true);
                for (int i2 = 1; i2 < undos.size(); ++i2) {
                    TableCellResizeUndoableEdit undo = (TableCellResizeUndoableEdit)((Object)undos.get(i2));
                    mainUndo.concatenate((UndoableEdit)((Object)undo));
                }
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)mainUndo), false);
                TableModelUtils.fixTableLayout(scene.getTable(), scene.getJasperDesign());
                return WidgetAction.State.CONSUMED;
            }
        }
        return WidgetAction.State.CONSUMED;
    }
}

