/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.outline.nodes.FieldNode;
import com.jaspersoft.ireport.designer.outline.nodes.FieldsNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class FieldsChildren
extends Index.KeysChildren
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignDataset dataset = null;
    private Lookup doLkp;

    public FieldsChildren(JasperDesign jd, Lookup doLkp) {
        this(jd, jd.getMainDesignDataset(), doLkp);
    }

    public FieldsChildren(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super(new ArrayList());
        this.jd = jd;
        this.doLkp = doLkp;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        this.dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new FieldNode(this.jd, (JRDesignField)key, this.doLkp)};
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public void recalculateKeys() {
        List l = (List)this.lock();
        l.clear();
        l.addAll(this.dataset.getFieldsList());
        if (this.getNode() != null && this.getNode() instanceof FieldsNode && ((FieldsNode)this.getNode()).isSort()) {
            Object[] fields = this.dataset.getFieldsList().toArray();
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JRDesignField)o1).getName().compareToIgnoreCase(((JRDesignField)o2).getName());
                }
            });
            l.clear();
            l.addAll(Arrays.asList(fields));
        }
        this.update();
    }

    protected void reorder(int[] ints) {
        if (this.getNode() != null && this.getNode() instanceof FieldsNode && ((FieldsNode)this.getNode()).isSort()) {
            return;
        }
        super.reorder(ints);
    }

    protected void forceReorder(int[] ints) {
        super.reorder(ints);
        this.update();
    }

    public void reorder() {
        Mutex.Action action = new Mutex.Action(){

            public Object run() {
                Index.Support.showIndexedCustomizer((Index)FieldsChildren.this.getIndex());
                return null;
            }
        };
        MUTEX.writeAccess(action);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("fields")) {
            this.recalculateKeys();
        }
    }
}

