/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import org.eigenbase.resgen.FileTask;
import org.eigenbase.resgen.PropertiesFileTask;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.XmlFileTask;
import org.eigenbase.xom.DOMWrapper;

public class ResourceGen {
    public static void main(String[] stringArray) throws IOException {
        ResourceGenTask resourceGenTask = ResourceGen.parse(stringArray);
        new ResourceGen().run(resourceGenTask);
    }

    static ResourceGenTask parse(String[] stringArray) {
        ResourceGenTask resourceGenTask = new ResourceGenTask();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-mode") && i + 1 < stringArray.length) {
                resourceGenTask.setMode(stringArray[++i]);
                continue;
            }
            if (string.equals("-srcdir") && i + 1 < stringArray.length) {
                resourceGenTask.setSrcdir(new File(stringArray[++i]));
                continue;
            }
            if (string.equals("-destdir") && i + 1 < stringArray.length) {
                resourceGenTask.setDestdir(new File(stringArray[++i]));
                continue;
            }
            if (string.equals("-resdir") && i + 1 < stringArray.length) {
                resourceGenTask.setResdir(new File(stringArray[++i]));
                continue;
            }
            if (string.equals("-locales") && i + 1 < stringArray.length) {
                resourceGenTask.setLocales(stringArray[++i]);
                continue;
            }
            if (string.equals("-style") && i + 1 < stringArray.length) {
                resourceGenTask.setStyle(stringArray[++i]);
                continue;
            }
            if (string.equals("-force")) {
                resourceGenTask.setForce(true);
                continue;
            }
            if (string.equals("-commentstyle")) {
                resourceGenTask.setCommentStyle(stringArray[++i]);
                continue;
            }
            ResourceGenTask.Include include = new ResourceGenTask.Include();
            resourceGenTask.addInclude(include);
            include.setName(string);
        }
        if (resourceGenTask.getIncludes().length == 0) {
            throw new Error("No input file specified.");
        }
        if (resourceGenTask.getDestdir() == null) {
            resourceGenTask.setDestdir(resourceGenTask.getSrcdir());
        }
        return resourceGenTask;
    }

    void run(ResourceGenTask resourceGenTask) throws IOException {
        resourceGenTask.validate();
        ResourceGenTask.Include[] includeArray = resourceGenTask.getIncludes();
        for (int i = 0; i < includeArray.length; ++i) {
            includeArray[i].process(this);
        }
    }

    void comment(String string) {
        System.out.println(string);
    }

    static String getResourceInitcap(ResourceDef.Resource resource) {
        String string = resource.name;
        if (string.equals(string.toUpperCase())) {
            return "_" + string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    static String getComment(ResourceDef.Resource resource) {
        DOMWrapper[] dOMWrapperArray = resource.getDef().getChildren();
        for (int i = 0; i < dOMWrapperArray.length; ++i) {
            DOMWrapper dOMWrapper = dOMWrapperArray[i];
            if (dOMWrapper.getType() != 3) continue;
            return dOMWrapper.getText();
        }
        return null;
    }

    FileTask createXmlTask(ResourceGenTask.Include include, String string, String string2, String string3, boolean bl, String string4, String string5, boolean bl2) {
        return new XmlFileTask(include, string, string2, string3, bl, string4, string5, bl2);
    }

    FileTask createPropertiesTask(ResourceGenTask.Include include, String string) {
        return new PropertiesFileTask(include, string);
    }
}

